<?php
	header('Content-Type: text/javascript');
	include("map.php");
?>
/**
 * CrmPlus+ Core Javascript Functions
 * Organized & Optimized
 */
var $ = jQuery.noConflict(); // Global jQuery alias

/* ==========================================================================
   1. YARDIMCI VE GENEL FONKSIYONLAR (UTILS)
   ========================================================================== */
function cevir(metin) {
    const r = {'A':'a','B':'b','C':'c','Ç':'c','ç':'c','D':'d','E':'e','F':'f','G':'g','Ğ':'g','ğ':'g','H':'h','I':'i','ı':'i','İ':'i','J':'j','K':'k','L':'l','M':'m','N':'n','O':'o','Ö':'o','ö':'o','P':'p','R':'r','S':'s','Ş':'s','ş':'s','T':'t','U':'u','Ü':'u','ü':'u','V':'v','Y':'y','Z':'z',' ':'-','/':'-',"'":'','"':'','!':'','.':'',',':'','+':'','_':'-','(': '',')':'','=':'','?':'','&':'','%':'','[':'इकिल',']':'','{':'','}':''};
    for (const [k, v] of Object.entries(r)) { metin = metin.replace(new RegExp(k, 'g'), v); }
    return metin;
}

function delay(callback, ms) {
    var timer = 0;
    return function() { var context = this, args = arguments; clearTimeout(timer); timer = setTimeout(function () { callback.apply(context, args); }, ms || 0); };
}

function darkmode() {
    document.body.classList.toggle("dark-mode");
    $('html').toggleClass("header-dark sidebar-light");
}

function vpass(ID) {
    var i = document.getElementById(ID);
    i.type = (i.type === "password") ? "text" : "password";
}

function setval(input, value) { $(input).val(value); }

function copyToClipboard(element) {
    var $temp = $("<input>");
    $("body").append($temp);
    $temp.val($(element).text()).select();
    document.execCommand("copy");
    $temp.remove();
    alert('Hafızaya Kopyalandı, Ctrl+V ile Yapıştırabilirsiniz.');
}

function SadeceRakam(e, allowedchars) {
    var key = e.charCode == undefined ? e.keyCode : e.charCode;
    if ((/^[0-9]+$/.test(String.fromCharCode(key))) || key == 0 || key == 13 || isPassKey(key, allowedchars)) { return true; }
    return false;
}

function isPassKey(key, allowedchars) {
    if (allowedchars != null) { for (var i = 0; i < allowedchars.length; i++) { if (allowedchars[i] == String.fromCharCode(key)) return true; } }
    return false;
}

function Checks(source) {
    var checkboxes = $(".dchck");
    for (var i = 0; i < checkboxes.length; i++) { if (checkboxes[i] != source) checkboxes[i].checked = source.checked; }
}

function sortTable(id, n) {
    var table, rows, switching, i, x, y, shouldSwitch, dir, switchcount = 0;
    table = document.getElementById(id); switching = true; dir = "asc";
    while (switching) {
        switching = false; rows = table.rows;
        for (i = 1; i < (rows.length - 1); i++) {
            shouldSwitch = false; x = rows[i].getElementsByTagName("TD")[n]; y = rows[i + 1].getElementsByTagName("TD")[n];
            if (dir == "asc") { if (x.innerHTML.toLowerCase() > y.innerHTML.toLowerCase()) { shouldSwitch = true; break; } } 
            else if (dir == "desc") { if (x.innerHTML.toLowerCase() < y.innerHTML.toLowerCase()) { shouldSwitch = true; break; } }
        }
        if (shouldSwitch) { rows[i].parentNode.insertBefore(rows[i + 1], rows[i]); switching = true; switchcount++; } 
        else { if (switchcount == 0 && dir == "asc") { dir = "desc"; switching = true; } }
    }
}

/* ==========================================================================
   2. UI & GÖRÜNÜM EFEKTLERİ (UI EFFECTS)
   ========================================================================== */
function hide(attr = '#preload') {
    if (attr.charAt(0) !== '#' && attr.charAt(0) !== '.') { attr = '#' + attr; }
    $(attr).fadeOut("slow");
}

function show(attr = '#preload') {
    if (attr.charAt(0) !== '#' && attr.charAt(0) !== '.') { attr = '#' + attr; }
    $(attr).fadeIn("slow");
}

function toggle(id) { $(id).toggle("slow"); }
function vtr(id) { var d = document.getElementById(id); d.style.visibility = "visible"; d.style.display = "table-row"; }
function htr(id) { var d = document.getElementById(id); d.style.visibility = "hidden"; d.style.display = "none"; }

function stime(id, islem, sure) {
    if (islem == "show") { $(id).fadeIn('slow'); } else { $(id).fadeOut('slow'); }
    if (sure != "") { setTimeout(function() { $(id).fadeOut('slow'); }, sure); }
}

function FullScreen(elem) {
    elem = elem || document.documentElement;
    if (!document.fullscreenElement && !document.mozFullScreenElement && !document.webkitFullscreenElement && !document.msFullscreenElement) {
        if (elem.requestFullscreen) { elem.requestFullscreen(); } 
        else if (elem.msRequestFullscreen) { elem.msRequestFullscreen(); } 
        else if (elem.mozRequestFullScreen) { elem.mozRequestFullScreen(); } 
        else if (elem.webkitRequestFullscreen) { elem.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT); }
    } else {
        if (document.exitFullscreen) { document.exitFullscreen(); } 
        else if (document.msExitFullscreen) { document.msExitFullscreen(); } 
        else if (document.mozCancelFullScreen) { document.mozCancelFullScreen(); } 
        else if (document.webkitExitFullscreen) { document.webkitExitFullscreen(); }
    }
}

function divyaz(divId) {
    var pC = document.getElementById(divId).innerHTML, oC = document.body.innerHTML;
    document.body.innerHTML = "<html><head><title></title></head><body>" + pC + "</body>";
    window.print(); document.body.innerHTML = oC;
}

function generatePDF(id) {
    let handlers = { 'no-export': function(element, renderer) { return true } };
    let doc = new jsPDF(), source = document.getElementById(id).innerHTML;
    doc.fromHTML(source, 10, 10, { "width": 595, "elementHandlers": handlers }, function(dispose) { doc.save("output.pdf") }, { top: 10, bottom: 10, left: 10, width: 595 });
}

/* ==========================================================================
   3. AJAX & VERI ISLEME ÇEKİRDEĞİ (AJAX CORE)
   ========================================================================== */
function loadContent(url, targetElement) {
    const loadingHtml = `<div class="loading-overlay"><p>Yükleniyor...</p></div>`;
    $.ajax({ url: url, type: 'GET', success: function(res) { $(targetElement).html(res); }, error: function(xhr, status, error) { $(targetElement).html('<div class="error">Hata oluştu.</div>'); console.error("Hata: ", error); } });
}

var loadFunction = function(path, did, nedir) {
    $(did).load("" + path + "?ne=<?php echo $_GET["ne"];?>&islem=<?php echo $_GET["islem"];?>&id=<?php echo $_GET["id"];?>&s5=<?php echo $_GET["s5"];?>&ts1=<?php echo $_GET["ts1"];?>&ts2=<?php echo $_GET["ts2"];?>&iq=<?php echo $_GET["iq"];?>&nedir=" + nedir + "");
}
var divload = function(url, did) { $(did).load(url); }

function Ajaxs(ID, result, func) {
    var url = $('#xf' + ID).attr('action'), id = '#xf' + ID, fname = 'xf' + ID;
    if (func == "AjaxPost") { AjaxPost(url, id, result); } else if (func == "Pcke") { Pcke(url, id, result, fname); }
    var btn = $('#b' + ID); var val = btn.html();
    btn.html('<i class="fa fa-clock-o"></i>');
    setTimeout(function() { btn.html(val); notice('CrmPlus+', '<?php echo $sdil[212]?>', 'fa fa-check', 'success'); }, 2000);
}

function AjaxPost(url, id, result, time, stext, etext) {
    time = time || 3000; stext = stext || "<?php echo trim($sdil[212])?>"; etext = etext || "<?php echo trim($sdil[9])?>";
    var pload = (url.substr(8, 3) != "xls");
    if (pload) $('#preload').fadeIn('slow');
    $.post(url, $(id).serialize()).done(function(data) {
        if (result.substr(0, 1) != "") {
            if (result.substr(0, 1) == "#") {
                if (data.trim().length > 0) { $(result).text(stext); if (pload) $('#preload').fadeOut('slow'); } else { $(result).text(etext); }
            } else if (result.substr(0, 1) == "n") {
                if (pload) $('#preload').fadeOut('slow');
                if (data.trim().length > 0) { notice(stext, stext, 'fa fa-check-square-o', 'success'); } else { notice(etext, etext, 'fa fa-times', 'danger'); }
            } else { setTimeout(function() { location.href = result }, time); }
        } else { setTimeout(function() { location.href = "<?php echo $weburl;?>" }, time); }
    });
    return false;
}

function AjaxGet(url, result, time, stext, etext) {
    time = time || 3000; stext = stext || "<?php echo trim($sdil[212])?>"; etext = etext || "<?php echo trim($sdil[9])?>";
    var pload = (url.substr(8, 3) != "xls");
    if (pload) $('#preload').fadeIn('slow');
    $.get(url).done(function(data) {
        if (result.substr(0, 1) != "") {
            if (result.substr(0, 1) == "#") {
                if (data.trim().length > 0) { $(result).text(stext); if (pload) $('#preload').fadeOut('slow'); } else { $(result).text(etext); }
            } else if (result.substr(0, 1) == "n") {
                if (pload) $('#preload').fadeOut('slow');
                if (data.trim().length > 0) { notice('<?php echo trim($sdil[212])?>', stext, 'fa fa-check-square-o', 'success'); } else { notice('<?php echo trim($sdil[9])?>', etext, 'fa fa-times', 'danger'); }
            } else { setTimeout(function() { location.href = result }, time); }
        } else { setTimeout(function() { location.href = "<?php echo $weburl;?>" }, time); }
    });
    return false;
}

function Pcke(url, id, result, fname) {
    for (var f in CKEDITOR.instances) CKEDITOR.instances[f].updateElement();
    $.ajax({ type: "POST", url: url, data: $(id).serialize(), success: function(data) {
        notice('CrmPlus+', '<?php echo $sdil[212]?>', 'fa fa-check', 'success');
        if (data != "") {
            if (data.substr(0, 4) == "url:") { location.href = data.replace('url:', ''); } 
            else { show(result.replace('#', '')); $(result).html(data); setTimeout(function() { hide(result.replace('#', '')); }, 3000); }
        }
    }});
    return false;
}

function AjaxGResult(url, id, result, pl, cke) {
    if (cke != '') { for (var f in CKEDITOR.instances) CKEDITOR.instances[f].updateElement(); }
    if (pl != 'nopl') { $('#preload').fadeIn('slow'); }
    $.post(url, $(id).serialize()).done(function(data) {
        if (data.substr(0, 4) == "url:") { location.href = data.replace('url:', ''); } 
        else if (result.substr(0, 1) == "#" || result.substr(0, 5) != "load:") { hide('preload'); show(result.replace('#', '')); $(result).html(data); } 
        else { hide('preload'); }
    });
    return false;
}

function AjaxPResult(url, id, result, pl, cke, callback) {
    if (cke != '') { for (var f in CKEDITOR.instances) CKEDITOR.instances[f].updateElement(); }
    if (pl != 'nopl') { $('#preload').fadeIn('slow'); }
    var form = $(id); var formdata = window.FormData ? new FormData(form[0]) : false;
    $.ajax({ url: url, data: formdata ? formdata : form.serialize(), cache: false, contentType: false, processData: false, type: 'POST', success: function(data) {
        if (data.substr(0, 4) == "url:") { location.href = data.replace('url:', ''); } 
        else { hide('preload'); show(result.replace('#', '')); $(result).html(data); }
        if (typeof callback === "function") callback();
        if (typeof loadurl !== "undefined") setTimeout(function() { location.href = loadurl; }, 500);
    }, error: function(xhr, status, error) { console.error("AJAX Hatası:", status, error); if (typeof callback === "function") callback(); } });
    return false;
}

function AjaxKaydet(fid, fname) {
    $('#preload').fadeIn('slow');
    fid = (fid === "") ? "#asave" : "#" + fid;
    for (var editor in CKEDITOR.instances) { if (CKEDITOR.instances.hasOwnProperty(editor)) { CKEDITOR.instances[editor].updateElement(); } }
    $.ajax({ type: "POST", url: $(fid).attr('action'), data: $(fid).serialize(), success: function(data) {
        if (data != "") {
            if (data.substr(0, 4) == "url:") { location.href = data.replace('url:', ''); } 
            else { const res = "#result"; show(res.replace('#', '')); $(res).html(data); setTimeout(function() { hide(res.replace('#', '')); }, 3000); }
        }
        $('#preload').fadeOut('slow'); notice('CrmPlus+', '<?php echo $sdil[212]; ?>', 'fa fa-check', 'success');
    }});
}

function AjaxKaydetYeni($fid, $fname) {
    $('#preload').fadeIn('slow');
    $fid = ($fid == "") ? "#asave" : "#" + $fid;
    for (var f in CKEDITOR.instances) CKEDITOR.instances[f].updateElement();
    $.ajax({ type: "POST", url: "?ne=<?php echo $_GET["ne"];?>&islem=<?php echo $_GET["islem"];?>&id=<?php echo $_GET["id"];?>&durum=kaydet", data: $($fid).serialize(), success: function() {
        $('#preload').fadeOut('slow');
        location.href = "?ne=<?php echo $_GET["ne"];?>&islem=<?php if($_GET["islem"]=="dsayfa"){echo "sayfa";}elseif($_GET["islem"]=="dkayit"){echo "kayitlar";}?>&id=<?php echo $_GET["id"];?>&durum=<?php if($_GET["islem"]=="dsayfa"){echo "ysayfa";}elseif($_GET["islem"]=="dkayit"){echo "ykayit";}?>";
    }});
}

/* ==========================================================================
   4. OLAY DİNLEYİCİLERİ (EVENT LISTENERS)
   ========================================================================== */
$(document).ready(function() {
    // QR Toggle
    $('.fa-sliders-h').click(function() { $('#q').toggleClass('qbr'); });

    // Dinamik Bilgi ve İkonlar
    var ts = [$(".v8-col200pxL-right").attr("ts1"), $(".v8-col200pxL-right").attr("ts2"), $(".v8-col200pxL-right").attr("ts3")];
    if (typeof ts[0] !== 'undefined') {
        $(".v8-col200pxL-right").append('<div class="v3-alert-warning" style="padding:5px; clear:both;"><i class="fa fa-plus text-warning"></i> ' + ts[0] + ' <i class="fa fa-refresh text-warning"></i> ' + ts[1] + ' <?php if($_GET["islem"]=="duye"){?><i class="fa fa-user text-warning"></i> ' + ts[2] + '<?php }?></div>');
    }
    $(".crm_info").each(function() { $(this).append('<i class="fas fa-question-circle info_icon text-info" data-toggle="tooltip" title="' + $(this).attr("data-info") + '"></i>'); });

    // Başlangıç Ayarları
    <?php if($darkmode=="1"){?> darkmode(); <?php }?>
    <?php if($e10==1 and $_SESSION["user"]=="admin"){?> $(".demo").attr("disabled", true); <?php }?>
    <?php if($E==1){?> $(".editor").attr("disabled", true); <?php }?>
    $('#preloader').fadeOut('slow');
    
    // Filtreleme & Formatlama
    $("#filtre").keyup(function() { var v = $(this).val().toLowerCase(); $(".filterable tr").filter(function() { $(this).toggle($(this).text().toLowerCase().indexOf(v) > -1) }); });
    $(".repdot").keyup(function() { $(this).val($(this).val().replace(",", ".")); });
    $('input,textarea,select,.bootstrap-tagsinput').addClass('notranslate');
    
    // AJAX İçerik Yükleme
    $(".dload").each(function() { $(this).load($(this).attr('data-load')); });
    $(".ufile").hover(function() { $(this).addClass('fa fa-upload').find("i").css("display", "none"); }, function() { $(this).removeClass('fa fa-upload').find("i").css("display", "block"); });
    $(".loading").click(function() { setTimeout(function() { $(".loading").attr("disabled", true).html('<img src="<?php echo $weburl?>/<?php echo $crmpath?>/assets/img/loading.gif" style="height:16px; margin-top:-5px"> <?php echo ctranslate("Yükleniyor")?>'); }, 100); });

    // Save OK Animasyon
    setTimeout(function() { $('#saveok').fadeIn('slow'); }, 500);
    setTimeout(function() { $('#saveok').delay(500).fadeOut('slow'); }, 500);

    // Form Validasyon (Döngüsel)
    for (let a = 0; a <= 10; a++) {
        let f = (a == 0) ? "" : a;
        fvalid('dr', a);
        $('form.fcontrol' + f).on('change keyup', function() { fvalid('', a); });
    }
    function fvalid(e, a) {
        $('.valert').remove(); if (a == 0) a = "";
        let c = 0, i = 0;
        $('form.fcontrol' + a + ' .icontrol').each(function() {
            $(this).removeClass("vclass");
            var valert = $(this).attr('data-alert'), type = this.type;
            if (type == "checkbox") {
                if ($(this).is(':checked')) { $(this).css("filter", "none"); } 
                else { c++; if (e != 'dr') { $(this).addClass('vclass'); if (valert) $(this).after('<div class="valert">* ' + valert + '</div>'); } }
            } else {
                if ($(this).val() == "") { i++; if (e != 'dr') { $(this).addClass('vclass'); if (valert) $(this).after('<div class="valert">* ' + valert + '</div>'); } } 
                else if (type == "email" && !/^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/.test($(this).val())) { $(this).after('<div class="valert">* <?php echo ctranslate("Mail Adresi Hatalı!")?></div>'); }
            }
        });
        $('form.fcontrol' + a + ' button').prop('disabled', (c != 0 || i != 0));
    }

    // Modal İşlemleri
    $(document).keypress(function(e) { if (e.keyCode == 27) $("#myModal").modal('hide'); });
    
    // Dinamik Modal Tetikleyiciler
    $(".majx").click(function() {
        var t = $(this).data("target"), w = $(this).attr("data-width"), u = $(this).attr("data-url"), r = $(this).attr("data-ref");
        $(t).fadeIn().css('width', ''); <?php if($mobile==""){?> if (w) $(t).css('width', w); <?php }?>
        $(".v3-modal-title").text($(this).attr("data-title"));
        if (r) $(t + ' .cmdl').attr('onclick', 'location.href=\'' + r + '\'');
        $(t + ' #modalajax').load(u);
    });

    $(".mfrm").click(function() {
        var d = $(this).data("ajax"), t = $(this).data("target"), w = $(this).attr("data-width"), u = $(this).attr("data-url"), r = $(this).attr("data-ref");
        var baseUrl = "<?php echo $weburl."/".$crmpath;?>/modules/";
        if(d=="mresim") { $('.cmdl').attr({url: baseUrl+"ajax/ajax_medya<?php if($path<>""){echo "_iframe";}?>.php?ne=<?php echo $_GET["ne"];?>&islem=<?php echo $_GET["islem"];?>&id=<?php echo $_GET["id"]; ?>&nedir=resim", result: "mresim"}); AjaxKaydet('',''); }
        else if(d=="mdosya") { $('.cmdl').attr({url: baseUrl+"ajax/ajax_medya<?php if($path<>""){echo "_iframe";}?>.php?ne=<?php echo $_GET["ne"];?>&islem=<?php echo $_GET["islem"];?>&id=<?php echo $_GET["id"]; ?>&nedir=dosya", result: "mdosya"}); AjaxKaydet('',''); }
        else if(d=="mvideo") { $('.cmdl').attr({url: baseUrl+"ajax/ajax_medya<?php if($path<>""){echo "_iframe";}?>.php?ne=<?php echo $_GET["ne"];?>&islem=<?php echo $_GET["islem"];?>&id=<?php echo $_GET["id"]; ?>&nedir=video", result: "mvideo"}); AjaxKaydet('',''); }
        else if(d=="icari") { $('.cmdl').attr({url: baseUrl+"clients/ajax_client_current.php?ne=<?php echo $_GET["ne"];?>&islem=<?php echo $_GET["islem"];?>&id=<?php echo $_GET["id"]; ?>", result: "icari"}); }
        
        $(t + " .v3-modal-title").text($(this).attr("data-title")); $(t).css('width', '');
        <?php if($mobile==""){?> if (w) $(t).css('width', w); <?php }?>
        if (r) $(t + ' .cmdl').attr('onclick', 'location.href=\'' + r + '\'');
        $(t + ' iframe').attr('src', u);
        $(t + ' .close').click(function() { $(t + ' iframe').attr('src', 'about:blank'); });
    });

    $(".cmdl").click(function(e) {
        $('#preload').fadeIn('slow'); e.preventDefault();
        var u = $('.cmdl').attr('url');
        if (u) { $('#' + $('.cmdl').attr("result")).load('<?php echo $path;?>' + u); } 
        else {
            var medUrl = '<?php echo $weburl."/".$crmpath;?>/modules/ajax/ajax_medya<?php if($path<>""){echo "_iframe";}?>.php';
            loadFunction(medUrl, '#mresim', 'resim'); loadFunction(medUrl, '#mvideo', 'video'); loadFunction(medUrl, '#mdosya', 'dosya');
            $('.modal-body iframe').attr('src', 'about:blank');
        }
        $('#preload').fadeOut('slow'); $('.modal').removeClass('in');
    });

    // Zamanlayıcı
    if(document.getElementById("wsaat")!=undefined){
        function digitalsaat(){
            var d = new Date(), h = d.getHours(), m = d.getMinutes(), s = d.getSeconds();
            wsaat.innerHTML = h + ':' + ((m<10)?'0':'') + m + ':' + ((s<10)?'0':'') + s; setTimeout(digitalsaat, 1000);
        }
        digitalsaat();
        var t=new Date(), a=['Ocak','Şubat','Mart','Nisan','Mayıs','Haziran','Temmuz','Ağustos','Eylül','Ekim','Kasım','Aralık'];
        $('#wts').html(t.getDate()+' '+a[t.getMonth()]+' '+t.getFullYear()+' '+['Pazar','Pazartesi','Salı','Çarşamba','Perşembe','Cuma','Cumartesi'][t.getDay()]);
    }
});

/* ==========================================================================
   5. MEDYA & SATIR İŞLEMLERİ (MEDIA & ROW ACTIONS)
   ========================================================================== */
$(document).on('click', 'a.tresim, a.tvideo, a.tdosya', function() {
    $('#preload').fadeOut('slow'); var t = $(this), h = t.data('href'), d = t.hasClass('tresim') ? 'resim' : (t.hasClass('tvideo') ? 'video' : 'dosya');
    $.get(h, function() { loadFunction(h, '#m' + d, d); });
});

$(document).on('input', '.mresim input, .mvideo input, .mdosya input', delay(function() {
    var t = $(this), id = t.closest('div').data('id'), v = t.val(), d = t.closest('.mresim').length ? 'resim' : (t.closest('.mvideo').length ? 'video' : 'dosya');
    var u = '<?php echo $weburl."/".$crmpath."/"?>modules/ajax/ajax_medya<?php if($path<>""){echo "_iframe";}?>.php';
    $.get(u + '?durum=msira&mid=' + id + '&s3=' + v, function() { loadFunction(u, '#m' + d, d); });
}, 1000));

$(document).on('click', '.btn-delete-div', function() {
    var t = $(this), d = t.closest('.mdiv, .hdiv, .cparent'), id = d.data('id'), box = $("#mb-remove-row");
    box.addClass("open");
    box.find(".mb-control-yes").off("click").on("click", function() {
        <?php if($_SESSION["V3Server"]<>""){?> document.getElementById('logfrm').src = "<?php echo $weburl?>/crmplus/modules/public/medya_delete.php?mid=" + id; <?php }?>
        $('#preload').fadeIn('slow'); box.removeClass("open");
        $.get(t.data('href'), function() { d.hide("slow", function() { d.remove(); $('#preload').fadeOut('slow'); }); });
    });
    box.find(".mb-control-close").on("click", function() { box.removeClass("open"); });
});

$(document).on('click', '.mb-add', function() {
    var t = $(this), box = $("#mb-add-row"); $('#mb-add-row').fadeIn('show');
    <?php if($module["SpeechText"][1]=="4" or $module["SpeechText"][2]=="4" or $module["SpeechText"][3]=="4"){?> speaker('<?php echo ctranslate("Kayıt eklemek istediğinize Eminmisiniz")?>'); <?php }?>
    box.find(".mb-control-yes").on("click", function() { $('#mb-add-row').fadeOut('slow'); $('#preload').fadeIn('slow'); location.href = t.data('href'); });
    box.find(".mb-control-close").on("click", function() { $('#mb-add-row').fadeOut('slow'); });
});

$('.mframe').each(function() { $(this).on("click", function() { document.getElementById['isrc'].src = $(this).data('target'); }); });

$(document).on('click', '.btn-delete-row, .btn-undo-row, .btn-all-clear', function() {
    var t = $(this), row = t.closest('tr'), id = row.data('id'), box = $(t.hasClass('btn-undo-row') ? "#mb-undo-row" : "#mb-remove-row");
    var d = { href: t.data('href'), did: (t.hasClass('btn-all-clear') ? t.data('did') : row.data('did')), url: (t.hasClass('btn-all-clear') ? t.data('href') : row.data('href')), ref_did: row.data('ref_id'), ref_href: row.data('ref_url') };
    
    box.addClass("open");
    <?php if($module["SpeechText"][1]=="4" or $module["SpeechText"][2]=="4" or $module["SpeechText"][3]=="4"){?> speaker('<?php echo ctranslate("İşlemi onaylıyor musunuz")?>'); <?php }?>
    
    box.find(".mb-control-yes").off("click").on("click", function() {
        if(t.hasClass('btn-delete-row')) { t.find('.fa').removeClass('fa-times').addClass('fa-clock-o'); <?php if($_SESSION["V3Server"]<>""){?> document.getElementById('logfrm').src = "<?php echo $weburl?>/crmplus/modules/public/medya_delete.php?id=" + id; <?php }?> }
        if(t.hasClass('btn-undo-row')) $('#preload').fadeIn('slow');
        box.removeClass("open");
        
        $.get(t.data('href'), function() {
            if(t.hasClass('btn-all-clear')) { loadFunction(d.url, d.did, ''); }
            else { row.hide("slow", function() { loadFunction(d.url, d.did, ''); if(d.ref_did) loadFunction(d.ref_href, d.ref_did, ''); row.remove(); $('#preload').fadeOut('slow'); }); }
        });
    });
    box.find(".mb-control-close").on("click", function() { box.removeClass("open"); });
});

$(document).on('click', '.btn-update-row', function() {
    var t = $(this), row = t.closest('tr');
    $.ajax({ type: "POST", url: row.data('action'), data: t.closest('form').serialize(), success: function(data) {
        loadFunction(row.data('url'), row.data('did'), '');
        if (data != "") {
            if (data.substr(0, 4) == "url:") location.href = data.replace('url:', '');
            else { if ($("#err").length) show('err'); $('#err').html(data); setTimeout(function() { if ($("#err").length) hide('err'); }, 3000); }
        }
        $('#preload').fadeOut('slow'); if (row.data('ref_id')) loadFunction(row.data('ref_url'), row.data('ref_id'), '');
    }});
});

/* Json Resim Upload */
$(document).on('change', '.ufiles, #udragdrop', function(e) {
    $('#preload').fadeIn('slow'); e.preventDefault();
    var t = $(this), fd = new FormData(); fd.append('dosya', t[0].files[0]);
    $.ajax({ url: t.closest('form').attr('action'), data: fd, type: 'POST', contentType: false, processData: false, success: function(data) {
        $(t.data('id')).fadeIn('slow').prepend('<img src="' + data.image + '" style="max-width:180px;" />');
        $('#preload').fadeOut('slow'); $(t.data('input')).fadeOut('slow'); $(t.data('dlink')).fadeIn('slow');
    }}, 'json');
});

$(document).on('click', '.btn-delete-img', function() {
    var t = $(this), box = $("#mb-remove-row"); box.addClass("open");
    box.find(".mb-control-yes").on("click", function() { box.removeClass("open"); $(t.data('h1')).fadeOut('slow'); $(t.data('h2')).fadeOut('slow'); $.get(t.data('href')); });
    box.find(".mb-control-close").on("click", function() { box.removeClass("open"); });
});

/* Sidebar & Card Actions */
$(document).on('click', '.sidebar-toggle', function() { $('#islem').load('fonksiyon.php?durum=sidebar'); });
$(document).on('click', '.card-action-close', function() { $('#islem').load('fonksiyon.php?durum=wdisable&ID=' + $(this).attr("data-id")); });

/* ==========================================================================
   6. SAYFAYA ÖZEL SCRIPTLER (PAGE SPECIFIC)
   ========================================================================== */
<?php if($_GET["page"]<>"scripts"){?>
function domo() { /* Shortcut definitions */ }
$(document).ready(domo);
$(document).bind('keydown', 'ctrl+s', function(e) { e.preventDefault(); $(".savebtn").click(); return false; });
$(document).bind('keydown', 'return', function(e) { e.preventDefault(); $(".mb-control-yes").click(); return false; });
$(document).bind('keydown', 'ctrl+left', function(e) { e.preventDefault(); $('#data-prev')[0].click(); return false; });
$(document).bind('keydown', 'ctrl+right', function(e) { e.preventDefault(); $('#data-next')[0].click(); return false; });
$(document).bind('keydown', 'ctrl+f', function(e) { e.preventDefault(); $('#q, .sinput').focus(); return false; });
$(document).bind('keydown', 'home', function(e) { e.preventDefault(); location.href = '?'; return false; });
<?php }?>

<?php if($_GET["ne"]<>""){?>
$(function() {
    $('.sidebar-right-toggle').click(function() {
        <?php if($_GET["islem"]=="ayarlar"){?> $('html').toggleClass("sidebar-right-opened"); $('#sidebar-right').css('margin-right', '0px'); <?php }?>
        $('#sidebar-right').load("fonksiyon.php?islem=guide&keys=<?php echo $_SESSION["user"]?>/<?php echo $_GET["ne"]?>/<?php echo $_GET["islem"]?>/<?php echo $_GET["id"]?>");
    });
});
<?php }?>

<?php if(count($colors)==1 and $t50<>""){?> $("#islem").load("fonksiyon.php?islem=colordedect"); <?php }?>
<?php if($MA<>1){?> $(document).keydown(function(e) { if (e.keyCode == 123) return false; }); <?php }?>

$(".scroller").click(function() { $('#set').animate({ scrollTop: $($(this).attr("data-href")).offset().top }, 'slow'); });

<?php if($_GET["islem"]=="dkayit" or $_GET["islem"]=="dsayfa" or $_GET["islem"]=="duye" or $_GET["islem"]=="dservice" or substr($_GET["islem"],1)=="fatura"){?>
$(document).on('keypress', 'input.form-control', function(e) {
    if (e.key === 'Enter') {
        e.preventDefault();
        <?php if($_GET["islem"]=="dkayit" or $_GET["islem"]=="dsayfa"){?> /* Action */ <?php }
        elseif($_GET["islem"]=="duye"){?> $(this).closest('#ncurrent, #ecurrent, #nservice, #eservice').find('.btn-update-row').click(); <?php }
        elseif(substr($_GET["islem"],1)=="fatura" or $_GET["islem"]=="dservice"){?> $(this).closest('.addtr, .uptr').find('.btn-update-row').click(); <?php }?>
    }
});
<?php }?>

function reload(url, id) { $('.cmdl').attr({url: url, result: id}); return false; }

<?php if($_GET['ne']=="kayit" or $_GET['ne']=="sayfa" or $_GET['ne']=="haber" or $_GET['ne']=="msayfa" or $_GET['ne']=="ayarlar" or $_GET['ne']=="uye" or $_GET['islem']=="tsms"){ if($_GET['file']=="add.php" || $_GET['page']=="scripts"){$fpath="../../";} ?>
$(document).ready(function() {
    $('.qcontrol').keyup(function() {
        var t = $(this); if (t.val() != '') { $.ajax({ url: '<?php echo $fpath;?>fonksiyon.php?ne=<?php echo $_GET["ne"];?>&islem=kontrol&veri=' + t.val(), type: 'POST', success: function(res) { document.getElementById(t.attr("qcontrol")).innerHTML = res; } }); }
    });
    $('#tck').keyup(function() { if ($(this).val() != '') { $.ajax({ url: 'fonksiyon.php?ne=<?php echo $_GET["ne"];?>&islem=tck&veri=' + $(this).val(), type: 'POST', success: function(res) { document.getElementById("ctck").innerHTML = res; } }); } });
});

$(function() {
    function charCnt(sel, max) {
        $(sel).bind('keydown keyup keypress change', function() {
            var s = (parseInt(0) + $(this).val().length); $(sel.replace('.', '#')).html(s + " < " + max).css({ color: (s > max ? '#ff0000' : '#000000') });
        });
    }
    charCnt('.ns1', 70); charCnt('.ns2', 160); charCnt('.smsx', 150); charCnt('.smsy', 150); charCnt('.ns3', 70);
});
<?php }?>