<?php
$path="../../../../";
include("../../../../map.php");
// Hesap Bilgileri
$username = tanim("mailing+im","n3",0);
$password = tanim("mailing+im","n2",0);
$accountCode = tanim("mailing+im","n5",0);
$apiKey = tanim("mailing+im","n1",0);
$vendorCode = 2;
// Token Alma
function getToken($username, $password, $accountCode, $apiKey, $vendorCode) {
    $url = "https://live.iletisimmakinesi.com/api/UserGatewayWS/functions/authenticate";
    $url .= "?userName=" . urlencode($username);
    $url .= "&userPass=" . urlencode($password);
    $url .= "&customerCode=" . urlencode($accountCode);
    $url .= "&apiKey=" . urlencode($apiKey);
    $url .= "&vendorCode=" . urlencode($vendorCode);
    $response = file_get_contents($url);
    // Gelen yanıtı kontrol edin
    if ($response === false) {
        die("API çağrısı başarısız oldu. Lütfen bağlantınızı kontrol edin.");
    }
    // Yanıt XML formatında olduğu için çözümleyelim
    libxml_use_internal_errors(true); // XML hata yönetimi
    $data = simplexml_load_string($response);
    if ($data === false) {
        die("XML çözümleme başarısız! Gelen yanıt: " . $response);
    }
    // TOKEN_NO değerini XML içerisinden al
    $token = (string)$data->CONTENT->AUTHORIZATION_WITH_TOKEN->TOKEN_NO ?? null;
    // Token kontrolü
    if (!$token) {
        die("Token alınamadı! Gelen yanıt: " . $response);
    }
    return $token;
}
// Servis Bilgilerini Alma
function getOriginatorId($token, $serviceId = 5) {
    $url = "https://live.iletisimmakinesi.com/api/UserGatewayWS/functions/getOriginators";
    $url .= "?token=" . urlencode($token);
    $url .= "&serviceId=" . urlencode($serviceId);
    $response = file_get_contents($url);
    // Gelen yanıtı kontrol edin
    if ($response === false) {
        die("API çağrısı başarısız oldu. Lütfen bağlantınızı kontrol edin.");
    }
    // XML olarak çözümle
    libxml_use_internal_errors(true); // XML hata yönetimi
    $data = simplexml_load_string($response);
    if ($data === false) {
        die("XML çözümleme başarısız! Gelen yanıt: " . $response);
    }
    // İlk Originator ID'yi XML içerisinden al
    $originators = $data->CONTENT->ORIGINATORS->ORIGINATOR;
    if ($originators) {
        foreach ($originators as $originator) {
            if ((int)$originator['service_id'] === $serviceId) {
                return (string)$originator['id']; // İlk uygun Originator ID'yi döndür
            }
        }
    }
    return null; // Eğer uygun bir ID bulunamazsa null döndür
}
function getBalance($token, $serviceId = 5) {
    $url = "https://api.iletisimmakinesi.com/api/endpoint/balance";
    $url .= "?token=" . urlencode($token);
    $url .= "&serviceId=" . urlencode($serviceId);
    $response = file_get_contents($url);
    if ($response === false) {
        die("API çağrısı başarısız oldu.");
    }
    $data = json_decode($response, true);
    if (isset($data['balance'])) {
        return $data['balance'];
    } else {
        return null;
    }
}
// Toplu Mail Gönderme
function sendBulkEmail($token, $originatorId, $emails, $subject, $content) {
    $url = "https://live.iletisimmakinesi.com/api/EmailGatewayWS/functions/sendEmail";
    $postData = [
        'token' => $token,
        'originatorId' => $originatorId,
        'emailAddresses' => json_encode($emails), // Email listesi JSON formatında
        'templateContent' => $content, // 'content' yerine 'templateContent'
        'emailSubject' => $subject // 'subject' yerine 'emailSubject'
    ];
    $options = [
        'http' => [
            'header'  => "Content-Type: application/x-www-form-urlencoded\r\n",
            'method'  => 'POST',
            'content' => http_build_query($postData)
        ]
    ];
    $context = stream_context_create($options);
    $response = @file_get_contents($url, false, $context);
    // Hata kontrolü: Eğer $response null veya boşsa
    if ($response === false) {
        return ['error' => 'Hata oluştu. Yanıt alınamadı.'];
    }
    $decodedResponse = json_decode($response, true);
    return $decodedResponse;
}
// Kullanım
$token = getToken($username, $password, $accountCode, $apiKey, $vendorCode);
if (!$token) {
    die("Token alınamadı!");
}
$originatorId = getOriginatorId($token);
if (!$originatorId) {
    die("Originator ID alınamadı!");
}
// Boş bir dizi oluştur
$emails = [];
// Tablodan tüm id ve t2 değerlerini çek
$sql = mysqli_query($conn, "SELECT id, t2 FROM t5 ORDER BY s1 ASC");
while ($rs = mysqli_fetch_assoc($sql)) {
    // $_POST["q"] içinde bu id varsa
    if (in_array($rs['id'], $_POST["q"])) {
        // t2 alanını Base64 çöz ve $emails dizisine ekle
        $emails[] = base64_decode($rs['t2']);
    }
}
$subject = $_POST["konu"]; // Mail başlığı
$content = $_POST["mesaj"]; // Mail içeriği
$response = sendBulkEmail($token, $originatorId, $emails, $subject, $content);
echo "Mailler başarıyla gönderildi!";
?>