<?php
$directory = '../../../alva/conversations/';
$files = array_diff(scandir($directory), array('.', '..'));

// Dosya listesini ters çevir (son gelen en üstte görünsün)
$files = array_reverse($files);

$output = [];

foreach ($files as $file) {
    if (pathinfo($file, PATHINFO_EXTENSION) === 'json') {
        $fileName = pathinfo($file, PATHINFO_FILENAME);

        // Dosya adında _ yoksa atla (hatalı dosya ismi)
        if (strpos($fileName, '_') === false) continue;

        list($datePart, $timePart) = explode('_', $fileName);
        $dateParts = explode('-', $datePart);
        if (count($dateParts) !== 3) continue;

        $formattedDate = $dateParts[2] . '.' . $dateParts[1] . '.' . $dateParts[0];
        $formattedTime = str_replace('-', ':', $timePart);

        // JSON içeriğini oku ve ilk mesajı al
        $fullPath = $directory . $file;
        $content = json_decode(file_get_contents($fullPath), true);

        $firstMessage = '';
        if (is_array($content) && count($content) > 0) {
            $firstMessage = $content[0]['content'] ?? '';
            $firstMessage = mb_strimwidth(strip_tags($firstMessage), 0, 50, '...');
        }

        $output[] = [
            'file' => $file,
            'datetime' => $formattedDate . ' ' . $formattedTime,
            'preview' => $firstMessage
        ];
    }
}

echo json_encode($output, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);