<?php
header('Content-Type: text/html; charset=utf-8');
$path = "../../";
include("../../map.php"); 

// 1. Hedef Dizin
$targetDir = dirname(__DIR__, 3) . '/';

// 2. Short Name Hazırlama
$domain = preg_replace('/^www\./', '', parse_url($weburl, PHP_URL_HOST) ?: $weburl);
$shortName = ucfirst(explode('.', $domain)[0]);

// 3. Dosya Yolları
$cleanFavicon = "/deppo/image/" . basename($favicon);
$cleanLogo    = "/deppo/image/" . basename($logo);

// 4. Manifest İçeriği (Öncelik Favicona Verildi)
$manifest = [
    "name" => $title,
    "short_name" => $shortName,
    "start_url" => "/index.php",
    "display" => "standalone",
    "background_color" => "#ffffff",
    "theme_color" => "#ff4d4d",
    "icons" => [
        [
            "src" => $cleanLogo,
            "sizes" => "192x192", // Logo boyutunu küçülterek ikincil plana attık
            "type" => "image/png"
        ],
        [
            "src" => $cleanFavicon,
            "sizes" => "512x512", // Favicon boyutunu 512 yaparak öncelik kazandırdık
            "type" => "image/png",
            "purpose" => "any maskable" // Android'in tercih sebebi olan yetkiyi buraya taşıdık
        ]
    ]
];

// 5. Service Worker
$serviceWorker = "const CACHE_NAME='tv-v1';const assets=['/','/index.php'];self.addEventListener('install',e=>{e.waitUntil(caches.open(CACHE_NAME).then(c=>c.addAll(assets)))});self.addEventListener('fetch',e=>{e.respondWith(caches.match(e.request).then(r=>r||fetch(e.request)))});";

// 6. JSON Yazma
$jsonFlags = JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES;
$manifestJson = json_encode($manifest, $jsonFlags);

if (file_put_contents($targetDir . 'manifest.json', $manifestJson) && file_put_contents($targetDir . 'sw.js', $serviceWorker)) {
    echo "<div style='font-family:sans-serif; padding:20px; border:1px solid #2ecc71; border-radius:8px; background:#fafffa;'>";
    echo "<b style='color:#27ae60;'>✓ PWA Ayarları Favikon Öncelikli Olarak Güncellendi</b><br><br>";
    echo "<b>Uygulama İkonu (Öncelikli):</b> $cleanFavicon (512x512, Maskable)<br>";
    echo "<b>Yedek İkon:</b> $cleanLogo (192x192)<br>";
    echo "</div>";
} else {
    echo "<b style='color:red;'>× Hata: Dosyalar yazılamadı.</b>";
}