<?php
header('Content-Type: text/html; charset=utf-8');
error_reporting(0);
$path = "../../";
include("../../map.php");
include("../../secure.php");
// JSON dosyasını yükle
$filePath = $_SERVER['DOCUMENT_ROOT'] . "/deppo/datas/translations.json";
// JSON dosyasına yaz
function writeTranslations($translations) {
    global $filePath;
    if (file_put_contents($filePath, json_encode($translations, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT)) === false) {
        // Hata durumu
        return false;
    }
    return true;
}
// JSON dosyasını oku
function readTranslations() {
    global $filePath;
    if (file_exists($filePath)) {
        $data = file_get_contents($filePath);
        $translations = json_decode($data, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            // JSON hatası
            return [];
        }
        return $translations;
    }
    return [];
}
if ($translations === []) {
    echo "Çeviri dosyası bulunamadı veya geçersiz format.";
} else {
    // Çevirileri işleme
    foreach ($translations as $id => $translation) {
        echo "ID: $id, Key: " . htmlspecialchars($translation['key'], ENT_QUOTES, 'UTF-8') . "<br>";
        // Diğer dillerin çevirilerini de işleyebilirsiniz
    }
}
?>
<?php
if (empty($_GET['durum']) || $_GET['durum'] == 'ok') {
    $diller = isset($m1) ? explode(',', $m1) : [];
    $translations = file_exists($filePath) ? json_decode(file_get_contents($filePath), true) : [];
    ?>
    <!DOCTYPE html>
    <html lang="tr">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Translate</title>
        <?php include("../../scripts.php"); ?>
    </head>
    <body>
        <div class="alert alert-warning" id="result" style="display:none;"></div>
        <div class="qmodal-header">
            <div class="header-title">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="?"><i class="fa fa-home"></i></a></li>
                        <li class="breadcrumb-item active" aria-current="page">Translate</li>
                    </ol>
                </nav>
            </div>
			<input type="text" id="tableFilter" class="filter-input" placeholder="Tabloda ara...">
            <button type="button" class="btn btn-warning" onclick="location.href='?'">
                <i class="fas fa-home"></i>
            </button>
            <button type="button" class="btn btn-info mfrm msa" data-toggle="modal" data-width="50%" data-target="#myModal" 
                    data-url="../../fonksiyon.php?islem=guide&keys=<?= $_SESSION['user'] ?>/<?= $_GET['ne'] ?>/<?= $_GET['islem'] ?>/<?= $_GET['id'] ?>">
                <i class="fas fa-info"></i>
            </button>
            <button type="button" class="btn btn-info mfrm msa" data-ref="?ne=<?= $_GET['ne']; ?>&islem=<?= $_GET['islem']; ?>" data-toggle="modal" data-width="50%" data-target="#myModal" data-url="../../fonksiyon.php?islem=initializeTranslations">
                <i class="fas fa-recycle"></i>
            </button>
        </div>
        <div style="padding: 0px 15px;">
            <div class="row">
                <div class="col-12">
                    <div class="tab-content" id="pills-tabContent">
                        <div class="tab-pane show active" id="pills-content-1" role="tabpanel">
                            <table class="table filterable" style="min-width:1000px;">
                                <tr class="addtr">
                                    <form method="POST" action="?ne=<?= $_GET['ne']; ?>&islem=<?= $_GET['islem']; ?>&durum=ekle" autocomplete="off" id="tform">
                                        <td class="w10">
                                            <input type="text" name="x20" list="txl" id="x20" class="form-control b1o" placeholder="Key">
                                            <datalist id="txl"></datalist>
                                        </td>
                                        <?php foreach ($diller as $index => $dil) { ?>
                                            <td>
                                                <input type="text" name="n<?= $index + 1 ?>" id="n<?= $index + 1 ?>" title="<?= $dil ?>" class="form-control b1o" placeholder="<?= $dil ?>">
                                            </td>
                                        <?php } ?>
                                        <td class="w8">
                                            <button class="btn btn-warning" type="submit"><i class="fa fa-plus"></i></button>
                                        </td>
                                    </form>
                                </tr>
                                <?php foreach ($translations as $id => $translation) { ?>
                                    <tr data-id="<?= $id; ?>">
                                        <form method="POST" action="?ne=<?= $_GET['ne']; ?>&islem=<?= $_GET['islem']; ?>&durum=duzenle&id=<?= $id; ?>" id="xf<?= $id; ?>">
                                            <input type="hidden" name="KID[]" value="<?= $id ?>" />
                                            <td>
                                                <span class="ddn mdn"> <?= $translation['key']; ?> </span>
                                                <input type="text" name="x20" class="form-control" value="<?= $translation['key']; ?>">
                                            </td>
                                            <?php foreach ($diller as $index => $dil) { ?>
                                                <td>
                                                    <input type="text" name="n<?= $index + 1 ?>" class="form-control" value="<?= $translation['lang' . ($index + 1)] ?? ''; ?>" placeholder="<?= $dil ?>">
                                                </td>
                                            <?php } ?>
                                            <td class="w8">
                                                <button class="btn btn-warning" type="button" onclick="Ajaxs('<?= $id; ?>','#result','AjaxPost');">
                                                    <i class="fa fa-refresh"></i>
                                                </button>
                                                <button type="button" class="btn btn-danger btn-delete-row" data-href="?ne=<?= $_GET['ne']; ?>&islem=<?= $_GET['islem']; ?>&durum=sil&id=<?= $id; ?>">
                                                    <i class="fa fa-times"></i>
                                                </button>
                                            </td>
                                        </form>
                                    </tr>
                                <?php } ?>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </body>
    </html>
    <script>
        jQuery('#x20').on('input', function() {
            var value = $(this).val();
            jQuery('#n1').val($('#txl [value="' + value + '"]').data('text'));
        });
    </script>
<?php } ?>
<?php
// Ekleme işlemi
if (isset($_GET['durum']) && $_GET['durum'] == 'ekle') {
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        // Gelen veriler
        $key = htmlspecialchars($_POST['x20'] ?? '', ENT_QUOTES, 'UTF-8');
        $translations = readTranslations();
        // Yeni ID oluştur
        $newId = max(array_keys($translations)) + 1;
        // Dillerin çevirilerini al
        $newTranslation = ['key' => $key];
        // Dillerin çevirilerini formdan al
        foreach ($_POST as $key => $value) {
            if (strpos($key, 'n') === 0 && !empty($value)) {
                $langNum = substr($key, 1);
                $newTranslation["lang$langNum"] = htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
            }
        }
        // Yeni çeviriyi JSON'a ekle
        $translations[$newId] = $newTranslation;
        writeTranslations($translations);
        header("Location: ?ne=".$_GET['ne']."&islem=".$_GET['islem']."");
    }
}
// Düzenleme işlemi
if (isset($_GET['durum']) && $_GET['durum'] == 'duzenle' && isset($_GET['id'])) {
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        // Gelen veriler
        $id = $_GET['id'];
        $translations = readTranslations();
        // Eğer ID mevcutsa, düzenle
        if (isset($translations[$id])) {
            // Dillerin çevirilerini al
            $translations[$id]['key'] = htmlspecialchars($_POST['x20'] ?? $translations[$id]['key'], ENT_QUOTES, 'UTF-8');
            // Dillerin çevirilerini formdan al
            foreach ($_POST as $key => $value) {
                if (strpos($key, 'n') === 0 && !empty($value)) {
                    $langNum = substr($key, 1);
                    $translations[$id]["lang$langNum"] = htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
                }
            }
            // Çeviriyi JSON'a kaydet
            writeTranslations($translations);
        }
		header("Location: ?ne=".$_GET['ne']."&islem=".$_GET['islem']."");
    }
}
// Silme işlemi
if (isset($_GET['durum']) && $_GET['durum'] == 'sil' && isset($_GET['id'])) {
    $id = $_GET['id'];
    $translations = readTranslations();
    // Eğer ID mevcutsa, sil
    if (isset($translations[$id])) {
        unset($translations[$id]);
        writeTranslations($translations);
    }
        header("Location: ?ne=".$_GET['ne']."&islem=".$_GET['islem']."");
}
echo $footer;
?>