self.addEventListener('install', e => { self.skipWaiting(); console.log('Service Worker kuruldu[sw]'); });
self.addEventListener('activate', e => { e.waitUntil(clients.claim()); console.log('Service Worker aktif[sw]'); });

// 🔁 Bildirim kontrol fonksiyonu
async function checkNotifications() {
  try {
    const res = await fetch('/crmplus/notifications.php?islem=notification&crm=1', { cache: 'no-store' });
    const data = await res.json().catch(() => null);
    if (data && Array.isArray(data.notifications) && data.notifications.length > 0) {
      data.notifications.forEach(notif => {
        self.registration.showNotification(notif.title, { body: notif.detail || '', icon: notif.icon || 'https://cdn-icons-png.flaticon.com/128/2058/2058148.png', data: { url: notif.weburl || '/' } });
      });
    }
  } catch (err) {
    console.error('Bildirim kontrol hatası[sw]:', err);
  }
}

// 🔁 Her 30 saniyede bir otomatik kontrol
setInterval(checkNotifications, 30000);

// 🔔 Bildirim tıklama olayını handle et (zaten açıksa yeniden açma)
self.addEventListener('notificationclick', e => {
  e.notification.close();
  e.waitUntil(
    clients.matchAll({ type: 'window', includeUncontrolled: true }).then(clientList => {
      for (const client of clientList) {
        if (client.url.includes('/crmplus/') && 'focus' in client) { return client.focus(); }
      }
      if (clients.openWindow && e.notification.data && e.notification.data.url) { return clients.openWindow(e.notification.data.url); }
    })
  );
});


// 📩 Page JS mesajlarını dinle
self.addEventListener('message', e => {
  if (e.data && e.data.action === 'checkNotifications') { checkNotifications(); }
});