<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>CRM+ API v1 Entegrasyon Dökümantasyonu</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background:#f6f8fb; }
.sidebar { position: sticky; top: 20px; height: calc(100vh - 40px); padding:15px; background:#fff; border-radius:12px; box-shadow:0 2px 12px rgba(0,0,0,0.05); }
.sidebar .nav-link { margin-bottom:5px; }
.content { max-height: calc(100vh - 40px); overflow-y:auto; padding-left:20px; }
.card { margin-bottom:20px; }
pre, code { background:#f5f7fa; border-radius:6px; padding:10px; }
.footer { margin-top:40px; text-align:center; font-size:13px; color:#666; border-top:1px solid #eee; padding-top:20px; }
.nav-link {
    display: block;
    padding: 0.5rem 0.75rem;
    font-size: 0.875rem;
    font-weight: 500;
    color: #fff !important;        /* Beyaz metin */
    text-decoration: none;
    background-color: #007bff;     /* Mavi buton arka planı */
    border-radius: 6px;            /* Hafif yuvarlak köşe */
    margin-bottom: 5px;
    transition: background-color 0.2s ease-in-out;
}

.nav-link:hover {
    background-color: #0056b3;     /* Hover rengi */
    color: #fff;
}

</style>
</head>
<body>
<div class="container-fluid py-3">
  <div class="row">
    <nav class="col-md-3 col-lg-2 sidebar">
      <ul class="nav flex-column">
        <li class="nav-item"><a class="nav-link btn btn-primary text-white" href="#auth">Kimlik Doğrulama</a></li>
        <li class="nav-item"><a class="nav-link btn btn-primary text-white" href="#env">API Ortamları</a></li>
        <li class="nav-item"><a class="nav-link btn btn-primary text-white" href="#product">Ürün İşlemleri</a></li>
        <li class="nav-item"><a class="nav-link btn btn-primary text-white" href="#user">Kullanıcı İşlemleri</a></li>
        <li class="nav-item"><a class="nav-link btn btn-primary text-white" href="#general">Genel İşlemler</a></li>
        <li class="nav-item"><a class="nav-link btn btn-primary text-white" href="#errors">Hata Kodları</a></li>
        <li class="nav-item"><a class="nav-link btn btn-primary text-white" href="#php">PHP Örnekleri</a></li>
      </ul>
    </nav>

    <main class="col-md-9 col-lg-10 content">

      <div class="card" id="auth">
        <div class="card-header text-primary">🔑 Kimlik Doğrulama</div>
        <div class="card-body">
          <p>Her istekte zorunlu parametreler:</p>
          <table class="table table-bordered">
            <thead class="table-primary"><tr><th>Parametre</th><th>Açıklama</th></tr></thead>
            <tbody>
              <tr><td><b>userid</b></td><td>SellerID</td></tr>
              <tr><td><b>user</b></td><td>Api Key</td></tr>
              <tr><td><b>pass</b></td><td>Api Secret Key</td></tr>
            </tbody>
          </table>
          <div class="alert alert-info">Örnek: ?userid=SellerID&user=ApiKey&pass=ApiSecretKey</div>
        </div>
      </div>

      <div class="card" id="env">
        <div class="card-header text-primary">🌍 API Ortamları</div>
        <div class="card-body">
          <table class="table table-bordered">
            <thead class="table-primary"><tr><th>Ortam</th><th>URL</th><th>Açıklama</th></tr></thead>
            <tbody>
              <tr><td><span class="badge bg-primary">Test</span></td><td>https://domain.com/api/v1/?test=1</td><td>Veritabanına yazılmaz, simülasyon döner.</td></tr>
              <tr><td><span class="badge bg-primary">Canlı</span></td><td>https://domain.com/api/v1/</td><td>Gerçek kayıt yapılır.</td></tr>
            </tbody>
          </table>
        </div>
      </div>

      <div class="card" id="product">
        <div class="card-header text-primary">🛒 Ürün İşlemleri</div>
        <div class="card-body">
          <h5>Ürün Ekleme (Insert)</h5>
          <pre>{
"title": "Deneme Ürünü",
"barcode": "BARKOD001",
"price": 149.90,
"price2": 129.90,
"stock": 25,
"currency": "TRY",
"images": ["https://cdn.crmplus.com.tr/sample1.png"]
}</pre>
          <h5>Ürün Güncelleme (Update)</h5>
          <pre>{
"title": "Güncellenmiş Ürün",
"barcode": "BARKOD001",
"price": 159.90,
"price2": 139.90,
"stock": 30,
"currency": "TRY",
"images": ["https://cdn.crmplus.com.tr/sample1.png"]
}</pre>
        </div>
      </div>

      <div class="card" id="user">
        <div class="card-header text-primary">👤 Kullanıcı İşlemleri</div>
        <div class="card-body">
          <h5>Kullanıcı Ekleme (Insert)</h5>
          <pre>{
"name": "Ali Veli",
"email": "ali@example.com",
"phone": "05551234567",
"address": "Ankara / Türkiye"
}</pre>
          <h5>Kullanıcı Güncelleme (Update)</h5>
          <pre>{
"name": "Ali Veli Güncel",
"email": "ali@example.com",
"phone": "05559876543",
"address": "İstanbul / Türkiye"
}</pre>
        </div>
      </div>

      <div class="card" id="general">
        <div class="card-header text-primary">⚙ Genel İşlemler</div>
        <div class="card-body">
          <p>Insert ve Update mantığı genel: endpoint ve id farkıyla çalışır, test modu eklenebilir.</p>
        </div>
      </div>

      <div class="card" id="errors">
        <div class="card-header text-primary">❌ Hata Kodları</div>
        <div class="card-body">
          <pre>{
"status": "error",
"message": "Unauthorized or invalid API credentials"
}</pre>
          <pre>{
"status": "error",
"message": "Missing required parameters"
}</pre>
        </div>
      </div>

      <div class="card" id="php">
        <div class="card-header text-primary">💻 Örnek PHP Entegrasyonu</div>
        <div class="card-body">
          <pre><code>
// $userid = 50;
// $base = "https://domain.com";
// $url = "$base/api/v1/?module=product&userid=$userid&user=ApiKey&pass=ApiSecretKey";
// test modu: &test=1
// curl init ve POST
// $data = {...};
// echo callAPI("product", $data, true);
</code></pre>
        </div>
      </div>

      <div class="footer">
        © 2025 CRM+ API v1 — Tüm hakları saklıdır.<br>
        Sürüm: 1.4.0
      </div>

    </main>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>