<?php
error_reporting(0);
session_start();

// Gelen isteğin türünü al (Örn: ?type=clone)
$type = isset($_GET["type"]) ? $_GET["type"] : "";

// 1. GRUP: Her senaryoda KESİNLİKLE hariç tutulacaklar (Sistem dosyaları, loglar, döngü yaratacak dosyalar)
$base_exclude = [
    '.', 
    '..', 
    'transfer.zip', // Kendi kendini ziplemesin
    'error_log', 
    '.error_log', 
    'online.txt',
    'sess_*' // Oturum dosyaları varsa
];

// 2. GRUP: Sadece kod güncellemesinde hariç tutulacaklar (Clone modunda bunlar DAHİL edilir)
$data_exclude = [
    'cache', 
    'logs', 
    'card', 
    'datas', 
    'chat', 
    'dosya', 
    'drive_files', 
    'excel', 
    'image', 
    'video', 
    'kategori', 
    'rek-lam', 
    'backup', 
    'slide', 
    'ses', 
    'assets', 
    'html', 
    'sql.php' // Config dosyası genelde clone'da taşınır, update'de korunur
];

// MANTIKSAL KARAR:
if ($type == "clone") {
    // CLONE MODU: Sadece temel sistem dosyalarını hariç tut.
    // Yani: Resimler, videolar, dosyalar ZIP'in içine GİRECEK.
    $exclude = $base_exclude;
} else {
    // STANDART MOD (Varsayılan): Hem sistem dosyalarını hem de ağır medya dosyalarını hariç tut.
    // Yani: Sadece kod yapısı ve modüller ZIP'e girecek.
    $exclude = array_merge($base_exclude, $data_exclude);
}

// --- İşlem Kodları Başlıyor ---

if ($_GET["op"] == "" || $_GET["op"] == "gzip") {
    
    // 3 üst dizine çıkarak ana dizini buluyoruz
    $targetDir = realpath(__DIR__ . '/../../../');
    
    if (!$targetDir || !is_dir($targetDir)) {
        exit("Hedef klasör bulunamadı.");
    }

    $zip_file_path = $targetDir . DIRECTORY_SEPARATOR . 'transfer.zip';

    class FlxZipArchive extends ZipArchive {
        private $exclude = [];

        public function __construct($exclude = []) {
            $this->exclude = $exclude;
        }

        public function addDirRecursive($location, $name) {
            $this->addEmptyDir($name);
            $this->addDirDo($location, $name);
        }

        private function addDirDo($location, $name) {
            $location = rtrim($location, '/') . '/';
            $name = rtrim($name, '/') . '/';

            if (!is_dir($location)) return;

            $dir = opendir($location);
            while (($file = readdir($dir)) !== false) {
                if (in_array($file, $this->exclude)) continue;

                $fullPath = $location . $file;
                $localPath = $name . $file;

                if (is_dir($fullPath)) {
                    $this->addEmptyDir($localPath);
                    $this->addDirDo($fullPath, $localPath);
                } else {
                    $this->addFile($fullPath, $localPath);
                }
            }
            closedir($dir);
        }
    }

    $za = new FlxZipArchive($exclude);
    $res = $za->open($zip_file_path, ZipArchive::CREATE | ZipArchive::OVERWRITE);
    
    if ($res === TRUE) {
        $dir = opendir($targetDir);
        while (($item = readdir($dir)) !== false) {
            if (in_array($item, $exclude)) continue;

            $fullPath = $targetDir . DIRECTORY_SEPARATOR . $item;
            
            if (is_dir($fullPath)) {
                $za->addDirRecursive($fullPath, $item);
            } else {
                $za->addFile($fullPath, $item);
            }
        }
        closedir($dir);
        $za->close();
        
        // Başarı mesajına mod bilgisini de ekleyelim
        echo "success|" . ($type == "clone" ? "FULL_BACKUP" : "CORE_UPDATE");
    } else {
        echo "Hata: transfer.zip oluşturulamadı.";
    }

} elseif ($_GET["op"] == "dzip") {
    $zip_file_path = realpath(__DIR__ . '/../../../') . DIRECTORY_SEPARATOR . 'transfer.zip';
    if (file_exists($zip_file_path)) {
        @unlink($zip_file_path);
        echo "silindi";
    } else {
        echo "zip zaten yok";
    }
}
?>