<?php
require_once('config.php');
/**
 * Register Card Request
 * Kart Kayıt Etme İsteği Oluştur
 */
$request = new \Hepsipay\Request\RegisterCardRequest();
/**
 * Set Options
 * Ayarları Set Et
 */
$request->setOptions($options);
$request->setFullName("John Doe"); // Kart İsim Soyisim (Maksimum 40 karakterdir. Sadece alfabetik karakterler ve boşluk kabul eder.)
$request->setCardNumber("5571135571135575"); // Kart Numarası (15 veya 16 haneli nümerik değerdir.)
$request->setExpireMonth("12"); // Kart Son Kullanım Tarihi (2 haneli nümerik değerdir.)
$request->setExpireYear("18"); // Kart Son Kullanım Tarihi (2 haneli nümerik değerdir.)
$request->setMerchantUserId("User_2"); // Kullanıcı kodu (Maksimum 40 karakterdir.)
$request->setMerchantUserCardId("Bankxxx_yyy_kartı"); // Kullanıcı kartı bilgisi kodu (Maksimum 40 karakterdir.)
/**
 * Make Request
 * İsteği Oluştur
 */
$response = \Hepsipay\Model\RegisterCard::create($request);
/**
 * Print Response ve Request Details
 * Yanıtı ve İstek Detaylarını Yazdır
 */
echo "<pre>";
echo "\nRESPONSE\n\n";
print_r($response); // Response
echo "\nREQUEST\n\n";
print_r($request->toJsonString()); // Request
echo "</pre>";