<?php
	$path="../../";
	include("../../map.php");
	include("script.php"); 
	$transactions = file_get_contents(__DIR__.'/datas/transactions.json');
	$result = json_decode($transactions, true);
?>
<div class="overflow-x-auto rounded-2xl shadow bg-white">
    <table class="table min-w-full divide-y divide-gray-200">
        <tbody class="divide-y divide-gray-100">
            <?php foreach($result as $key=>$value){  $tdate = date("Y-m-d", strtotime($value["activityDate"]));?>
                <tr data-id="<?php echo $i; ?>" class="hover:bg-gray-50">
                    <td class="p-3 w-24 align-top" style="<?php echo ($value['amount'] < 0) ? 'border-left:5px solid ' . $module['clrcdanger'] : 'border-left:5px solid ' . $module['clrcsuccess']; ?>">
                        <div class="flex flex-col items-center">
                            <span class="text-lg font-bold leading-4"><?php echo dtarih($tdate, "gg"); ?></span>
                            <span class="text-xs text-gray-500"><?php echo dtarih($tdate, "ua yyyy"); ?></span>
                        </div>
                    </td>
                    <td class="p-3 w-12 text-center align-middle">
                        <img src="https://cdn.crmplus.com.tr/images/banks/ib<?php echo $value['bankID']; ?>.png" alt="Banka" class="h-6 inline-block">
                    </td>
                    <td class="p-3 font-semibold align-middle">
                        <?php echo $value['explanation']; ?>
                    </td>
                    <td class="p-3 w-56 font-semibold align-middle">
                        <?php echo $value['IBAN']; ?>
                    </td>
                    <td class="p-3 w-36 text-right align-middle font-semibold" style="<?php echo ($value['amount'] < 0) ? 'color:' . $module['clrcdanger'] : 'color:' . $module['clrcsuccess']; ?>">
                        <?php echo number_format($value['amount'], 2); ?> TL
                    </td>
                    <td class="p-3 w-12 text-right align-middle">...</td>
                </tr>
            <?php } ?>
        </tbody>
    </table>
</div>