<?php
$path="../../";
include("../../map.php");
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>Updater</title>
  <link rel="icon" type="image/png" href="https://cdn-icons-png.flaticon.com/128/9147/9147804.png" />
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" />
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <link href="https://fonts.googleapis.com/css2?family=Share+Tech+Mono&display=swap" rel="stylesheet">
  <style>
    body { font-family: 'VT323', monospace; font-size: 16px; }
    #log { background-color: #000000; color: #00FF00; font-family: 'Share Tech Mono', monospace; white-space: pre-wrap; overflow-y: auto; flex-grow: 1; padding: 20px; font-size: 16px; line-height: 1.5; height: 100vh; box-sizing: border-box; }
    #log a { color: #00BFFF; text-decoration: underline; }
    #log a:hover { color: #FFFFFF; background-color: #333; }
    #log::after { content: "█"; animation: blink 1s steps(1) infinite; display: inline-block; margin-left: 5px; }
    @keyframes blink {
      0%, 50% {opacity: 1;}
      50.01%, 100% {opacity: 0;}
    }
  </style>
</head>
<body class="bg-light">
  <div class="container-fluid mt-3">
    <h2 class="mb-3 d-flex justify-content-between align-items-center"><i class="fas fa-home me-2" onclick="location.href='?'" style="cursor:pointer"></i> CrmPlus AI – Content Manager</h2>

    <div class="row" style="height: calc(100vh - 100px);">
      <!-- Sol Sütun -->
      <div class="col-md-4 h-100">
        <div class="card p-3 shadow-sm bg-white h-100">

<?php
if (!empty($_GET['id'])) {
    $sql = mysqli_query($conn, "SELECT * FROM ".$_SESSION['lang']." WHERE id = ".$_GET['id'].""); $rs = mysqli_fetch_assoc($sql); $ne=$rs["ne"];
	$promt='"'.$rs["t1"].'" başlığına uygun seo uyumlu içerik hazırla';
	$id=$rs["id"];
}else{
	$promt="Başlıklara göre seo uyumlu içerikleri hazırla";
	$id="";
}
?>
          <form id="updateForm">
            <!-- Metin Kutusu -->
            <div class="mb-3">
              <label for="prompt" class="form-label">Talimat / Metin</label>
              <textarea id="prompt" name="prompt" class="form-control" rows="5" placeholder="Örn: Başlık ile ilgili açıklayıcı metin üret..."><?php echo $promt;?></textarea>
            </div>

            <!-- Güncellenecek Sütunlar -->
            <div class="mb-3">
              <label class="form-label">Sütunlar</label><br>
              <div class="form-check form-check-inline" style="display: block;">
                <input class="form-check-input" type="checkbox" name="columns[]" value="t1" id="colT1" checked>
                <label class="form-check-label" for="colT1">Başlık (t1)</label>
              </div>
              <div class="form-check form-check-inline" style="display: block;">
                <input class="form-check-input" type="checkbox" name="columns[]" value="n1" id="colN1" checked>
                <label class="form-check-label" for="colN1">Detay (n1)</label>
              </div>
              <div class="form-check form-check-inline" style="display: block;">
                <input class="form-check-input" type="checkbox" name="columns[]" value="n2" id="colN2" checked>
                <label class="form-check-label" for="colN2">Kısa Açıklama (n2)</label>
              </div>
              <div class="form-check form-check-inline" style="display: block;">
                <input class="form-check-input" type="checkbox" name="columns[]" value="n3" id="colN3" checked>
                <label class="form-check-label" for="colT1">Seo Başlık (n3)</label>
              </div>
              <div class="form-check form-check-inline" style="display: block;">
                <input class="form-check-input" type="checkbox" name="columns[]" value="n4" id="colN4" checked>
                <label class="form-check-label" for="colN4">Anahtar Kelimeler (n4)</label>
              </div>
              <div class="form-check form-check-inline" style="display: block;">
                <input class="form-check-input" type="checkbox" name="columns[]" value="n9" id="colN9">
                <label class="form-check-label" for="colN9">Özet (n9)</label>
              </div>
            </div>

            <!-- Tablo / Kategori Seçimi -->
            <div class="mb-3">
              <label for="table" class="form-label">Modül</label>
              <select id="table" name="table" class="form-select">
                <option value="sayfa" <?php if($ne == 'sayfa') echo 'selected'; ?>>Sayfalar</option>
                <option value="haber" <?php if($ne == 'haber') echo 'selected'; ?>>Haberler</option>
                <option value="kayit" <?php if($ne == 'kayit') echo 'selected'; ?>>Ürünler</option>
			<?php $sqlx=mysqli_query($conn, "select id,n1,n2 from genel where ne='xmodules' order by s10 asc,id desc"); while($rsx=mysqli_fetch_assoc($sqlx)){?>
				<option value="<?php echo $rsx["n2"]?>" <?php if($ne == $rsx["n2"]) echo 'selected'; ?>><?php echo $rsx["n1"]?></option>
			<?php }?>
              </select>
            </div>

			<!-- Adet / PID / Limit Seçimi -->
				<div class="mb-3">
				  <a class="form-label d-block" data-bs-toggle="collapse" href="#paramsCollapse" role="button" aria-expanded="false" aria-controls="paramsCollapse" style="cursor:pointer;">
					<strong>Ek Parametreler</strong>
					<i class="fa fa-chevron-down ms-1"></i>
				  </a>

				  <div class="collapse mt-2" id="paramsCollapse">
					<div class="row g-2">
					  <div class="col-md-4" title="Yeni içerik oluşturulacaksa, eklenecek kayıt sayısını girin.">
						<label for="count" class="form-label">Yeni İçerik</label>
						<input type="number" id="count" name="count" class="form-control" min="0" value="0">
						<small class="form-text text-muted" style="font-size:10px;">0’dan büyükse ekler</small>
					  </div>

					  <div class="col-md-4" title="Belirli bir kayıt ID’sini düzenlemek için kullanılır.">
						<label for="pid" class="form-label">Kayıt ID</label>
						<input type="text" id="pid" name="pid" class="form-control" value="<?php echo $id?>" placeholder="#">
						<small class="form-text text-muted" style="font-size:10px;">#ID düzenlenir</small>
					  </div>

					  <div class="col-md-4" title="İşlem yapılacak kayıt aralığını belirler. Örn: 0,20">
						<label for="limit" class="form-label">Limit</label>
						<input type="text" id="limit" name="limit" class="form-control" value="" placeholder="0,20">
						<small class="form-text text-muted" style="font-size:10px;">İşlenecek kayıt aralığı</small>
					  </div>
					</div>
				  </div>
				</div>

            <button type="submit" class="btn btn-success">
              <i class="fas fa-rocket me-2"></i>Başla
            </button>
          </form>

        </div>
      </div>

      <!-- Sağ Sütun -->
      <div class="col-md-8 h-100">
        <div class="card p-3 shadow-sm bg-white h-100 d-flex flex-column">
          <h5 class="mb-3">Process Console</h5>
          <div id="log">Welcome to CrmPlus Update Mode. Ready for instructions...</div>
        </div>
      </div>
    </div>
  </div>

  <!-- Bootstrap 5 JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
	<script>
		document.querySelector("#updateForm").addEventListener("submit", function(e){
		  e.preventDefault();
		  const logDiv = document.querySelector("#log");
		  logDiv.innerText = ">> İşleme başlandı...\n";

		  const formData = new FormData(this);
		  const query = new URLSearchParams(formData).toString();

		  const evtSource = new EventSource("ai_process.php?" + query);

		  evtSource.onmessage = function(event) {
			logDiv.innerText += event.data + "\n";
			logDiv.scrollTop = logDiv.scrollHeight;
		  };

		  evtSource.onerror = function() {
			logDiv.innerText += "⚠️ Bağlantı kapandı.\n";
			evtSource.close();
		  };
		});
		</script>


</body>
</html>