<?php
$path="../../";
include("../../map.php");
include("../../secure.php");
include("../../scripts.php");

function get_ssl_info($host) {
$ctx = stream_context_create([
    "ssl" => [
        "capture_peer_cert" => true,
        "verify_peer" => false,
        "verify_peer_name" => false,
    ]
]);
$client = @stream_socket_client("ssl://{$host}:443", $errno, $errstr, 30, STREAM_CLIENT_CONNECT, $ctx);
if (!$client) return null;

$params = stream_context_get_params($client);
return openssl_x509_parse($params["options"]["ssl"]["peer_certificate"]);
}

$domain = $_SERVER['SERVER_NAME'];
$ip_address = gethostbyname($domain);
$client_ip = $_SERVER['REMOTE_ADDR'];
$os = PHP_OS_FAMILY;
$ssl = get_ssl_info($domain);

$data = file_get_contents('https://cdn.crmplus.com.tr/data');
$json = json_decode($data); // JSON objesi
$servicesList = null;

foreach ($json->data as $item) {
	if ($item->type === 'services') {
		$servicesList = $item->list;
		break;
	}
}

$currentDomain = $_SERVER["SERVER_NAME"];
$matchedUserId = null;
$result = [];

foreach ($servicesList as $item) {
	$domain = $item->domain;
	if (strpos($domain, $currentDomain) !== false || strpos($currentDomain, $domain) !== false) {
		$matchedUserId = $item->User_ID;
		break;
	}
}

if ($matchedUserId !== null) {
	foreach ($servicesList as $item) {
		if ($item->User_ID == $matchedUserId) {
			$result[] = [ 'domain' => $item->domain, 'type' => $item->type, 'start' => $item->start, 'finish' => $item->finish, ];
		}
	}
}

?>

<!doctype html>
<html lang="tr">
<head>
<meta charset="UTF-8">
<title>Web Sitesi Künyesi</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
</head>
<body class="bg-light">

<div class="container">
<div class="">
    <div class="card-body">
        <table class="table table-bordered table-hover">
            <tbody>
				<tr class="bg-info">
                        <th colspan="2"><i class="fa-solid fa-circle-info me-2"></i> Web Sitesi Künyesi</th>
                    </tr>
                <tr>
                    <th><i class="fa-solid fa-globe me-2"></i> Alan Adı</th>
                    <td><?= htmlspecialchars($domain) ?></td>
                </tr>
                <tr>
                    <th><i class="fa-solid fa-server me-2"></i> Sunucu IP Adresi</th>
                    <td><?= $ip_address ?></td>
                </tr>
                <tr>
                    <th><i class="fa-solid fa-user me-2"></i> Müşteri IP Adresi</th>
                    <td><?= $client_ip ?></td>
                </tr>
                <tr>
                    <th><i class="fa-solid fa-desktop me-2"></i> Hosting Türü</th>
                    <td><?= $os ?></td>
                </tr>
                <?php if ($ssl): ?>
                    <tr>
                        <th><i class="fa-solid fa-lock me-2"></i> SSL Sağlayıcı</th>
                        <td><?= $ssl['issuer']['O'] ?? 'Bilinmiyor' ?></td>
                    </tr>
                    <tr>
                        <th><i class="fa-solid fa-calendar-plus me-2"></i> SSL Başlangıç</th>
                        <td><?= date('d-m-Y H:i:s', $ssl['validFrom_time_t']) ?></td>
                    </tr>
                    <tr>
                        <th><i class="fa-solid fa-calendar-minus me-2"></i> SSL Bitiş</th>
                        <td><?= date('d-m-Y H:i:s', $ssl['validTo_time_t']) ?></td>
                    </tr>
                    <tr>
                        <th><i class="fa-solid fa-id-badge me-2"></i> SSL Ortak Ad (CN)</th>
                        <td><?= $ssl['subject']['CN'] ?? 'Yok' ?></td>
                    </tr>
                <?php else: ?>
                    <tr>
                        <th><i class="fa-solid fa-lock-open me-2"></i> SSL Bilgisi</th>
                        <td>Yok veya alınamadı.</td>
                    </tr>
                <?php endif; ?>
                    <tr class="bg-info">
                        <th colspan="2"><i class="fa-solid fa-circle-info me-2"></i> Hizmetler</th>
                    </tr>
<?php foreach ($result as $r) {?>
                    <tr>
                        <th><i class="fa-solid fa-globe me-2"></i> <?php echo $r['domain']?><br><span style="font-size:12px"><?php echo $r['type']?></span></th>
                        <td><?php echo dtarih($r['finish'],"gg ka yy")?> (<?php if(daynow($r['finish'])>0){echo daynow($r['finish'])." gün kaldı";}else{echo daynow($r['finish'])." gün geçti";}?> )</td>
                    </tr>
<?php }?>
            </tbody>
        </table>
    </div>
</div>
</div>

<!-- Bootstrap JS (isteğe bağlı) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>