<style>
.gear {
  position:absolute;
  display:block;
  margin:60px auto;
  width:0; 
  height:0;
  border-radius:50%;
  border:0 solid #444;
  & .gearTooth {
    position:absolute;
    display:block;
    background-color:transparent;
    width:12px;
    height:6px;
    padding-bottom:94px;
    z-index:100;
    transform-origin:50% 50%;
    margin:0 auto;
    top:-30px;
    left:14px;
    &::before {
      content:'';
      position:relative;
      display:block;
      width:12px;
      height:20px;
      background-color:#444;
    }
  }
}
<style>
<script>
function getRandomInt(min, max) {
  return Math.floor(Math.random() * (max - min + 1)) + min;
}
function initGear(){
  //create a variable representing our gear div.
  var $gear = jQuery('<div class="gear"></div>');
  
  jQuery('body').append($gear);
  
  $gear.velocity({
    width: 40,
    height: 40,
    borderWidth: 24},200,'ease-in', addTeeth);
  //create a jQuery object of the element that
  //will be each gear tooth.
  var $gearTooth = jQuery('<div class="gearTooth"></div>');
  //set initial gear tooth position around
  //gear. one might alter this variable to
  //create a gear with missing teeth.
  var rotationIndex = 0;
  
  function addTeeth() {
    //append gear teeth to div.gear element
    for (var i=0;i<12;i++) {
      var xPos = getRandomInt(-400,400);
      var yPos = getRandomInt(-400,400);    
      $gearTooth
        .clone()
        .appendTo($gear)
      .velocity({tranlateX: xPos,translateY:[0,yPos], rotateZ: rotationIndex},1000,'ease')
      //set each gear tooth to be rotated around center of gear slightly
      rotationIndex += 30;
    }
  }
  setTimeout(spinGear,500);
};
//this function initiates the gear spin.
function spinGear() {
  //note that this uses velocity, not
  //the standard jQuery .animate.
  //velocityjs is awesome! See:
  ////github.com/julianshapiro/velocity
  jQuery('.gear').velocity({rotateZ: 3000}, 36000, 'ease');
}
jQuery(document).ready(function(){
  if (jQuery('.gear').length === 0 ) {
    initGear();
  }
});
jQuery('.stopAnimation').on('click', function(){
  //This is velocity's manual stop command.
  jQuery('.gear').velocity('stop');
  jQuery('.gear').css({'transform': 'rotate(0)'});
  jQuery('.gearTooth').velocity({
    translateX: [250,0]
  },500,'ease');
  jQuery('.gearTooth').velocity({
    translateY: [1000,0]
  },500,'ease-in', function(){
     jQuery('.gear').fadeOut(function(){
       jQuery('.gear').remove();
     });
  });
});
</script>