// jquery.js
(function(){
    // URL'deki script taglerini bul
    var scripts = document.getElementsByTagName('script');
    var params = {};

    for (var i = 0; i < scripts.length; i++) {
        var src = scripts[i].src;
        if (src && src.indexOf('jquery.js') !== -1) { // kendi js dosyanı bul
            var queryString = src.split('?')[1]; // ? sonrası
            if(queryString){
                var searchParams = new URLSearchParams(queryString);
                params.sayfa = searchParams.get('sayfa');
                params.id = searchParams.get('id');
                params.cpath = searchParams.get('cpath');
            }
            break;
        }
    }

    // Global olarak erişilebilir yap
    window.MyParams = params;
})();

// Base64 çözümleme fonksiyonu — hatalıysa orijinal değeri döner  
function decodeBase64(s){try{return s?atob(s):''}catch(e){console.warn('Geçersiz Base64:',s);return s}}


var cpath = decodeBase64(window.MyParams.cpath || '');
var crmpath = decodeBase64(window.MyParams.crmpath || '');
var weburl = decodeBase64(window.MyParams.weburl || '');
var ID = window.MyParams.id || '';
var sayfa = window.MyParams.sayfa || '';
var sayfa3 = window.MyParams.sayfa3 || '';
var mobile = /Mobi|Android/i.test(navigator.userAgent) ? "1" : "";

function Checks(source){
	//var checkboxes = document.querySelectorAll('input[type="checkbox"]');
	var checkboxes = jQuery(".dchck");
	for (var i = 0; i < checkboxes.length; i++) {
		if (checkboxes[i] != source)
		checkboxes[i].checked = source.checked;
	}
}

jQuery(document).ready(function () {
    jQuery('img[class*="cropped"]').each(function () {
        var classes = jQuery(this).attr('class').split(' ');
        var height = 200; // varsayılan yükseklik

        classes.forEach(function (cls) {
            if (cls.startsWith('cropped-')) { // başındaki boşluğu kaldırdım
                var value = cls.split('-')[1];
                if (!isNaN(value)) {
                    height = parseInt(value, 10);
                }
            }
        });

        jQuery(this).css({ 'height': height + 'px', 'object-fit': 'cover', 'width': '100%', 'border-radius': '7px' });
    });
});

// delay(callback, ms): Belirtilen süre (ms) kadar gecikmeli olarak bir fonksiyonu çalıştırır  
// Örnek: input alanında yazma bittikten 500ms sonra işlem yapmak için kullanılır
function delay(cb,ms){var t=0;return function(){var c=this,a=arguments;clearTimeout(t);t=setTimeout(function(){cb.apply(c,a)},ms||0)}}


// darkmode(): Oturum bazlı koyu/açık tema geçişini kontrol eder  
// Eğer sessionStorage.theme "dark" ise <html> etiketine 'dark' sınıfı ekler, değilse kaldırır
function darkmode(){if(sessionStorage.theme=="dark"){jQuery("html").addClass("dark");sessionStorage.setItem("theme","dark");}else{jQuery("html").removeClass("dark");sessionStorage.setItem("theme","light");}}

// 🌙 Tema değiştirici: Kullanıcı butona tıkladığında dark/light mod arasında geçiş yapar  
// Mevcut tema sessionStorage’da saklanır ve sayfa yenilendiğinde darkmode() ile geri yüklenir  
jQuery(".dark-mode-switch").click(function(){if(sessionStorage.theme=="dark"){jQuery("html").removeClass("dark");sessionStorage.setItem("theme","light");}else{jQuery("html").addClass("dark");sessionStorage.setItem("theme","dark");}});darkmode();

// 🛒 Ürün sepet işlemleri fonksiyonu (id: ürün ID’si, qty: miktar)
// Sepete ekleme işlemini AJAX ile yapar, sonucu bildirim alanında gösterir
function jBasket(id,qty){jQuery('#v3-notification').fadeOut('slow').fadeIn('slow');var basketurl=cpath+"config/ajax.php?islem=jbasket&id="+id+"&qty="+qty;jQuery.get(basketurl).done(function(data){jQuery('#v3-notification').html(data);stime('#v3-notification','show','3200');});return false;}

// 🛒 Sepete ekleme işlemi (id = ürün ID, qty = miktar); AJAX ile gönderir ve sonucu bildirim alanında gösterir
function jBasket(id,qty){jQuery('#v3-notification').fadeOut('slow').fadeIn('slow');var basketurl=cpath+"config/ajax.php?islem=jbasket&id="+id+"&qty="+qty;jQuery.get(basketurl).done(function(data){jQuery('#v3-notification').html(data);stime('#v3-notification','show','3200');});return false;}

jQuery('.v3-step').each(function(index,el){jQuery(el).not('.active').addClass('done');jQuery('.done').html('<i class="fas fa-check"></i>');if(jQuery(this).is('.active')) return false;});

// 📝 T.C. Kimlik Numarası doğrulama fonksiyonu (11 haneli ve kurallara uygun mu kontrol eder)
(function($){$.fn.tck=function(){var a=this.val(),c=0,d=0,e=0,b=0,f=0;if(a.charAt(0)==0||a.length!=11)return false;b=parseInt(a.charAt(9),10);f=parseInt(a.charAt(10),10);for(var i=0;i<9;i++){var cd=parseInt(a.charAt(i),10);i%2==0?c+=cd:d+=cd;e+=cd}return (7*c-d)%10==b&&(e+b)%10==f}})(jQuery);


// 🛠 Varyasyon seçimi ve stok/fiyat kontrol fonksiyonu (data-id ve data-name kullanır, AJAX ile günceller)
function check(e){var n=e.getAttribute("data-name"),i=e.getAttribute("data-id");jQuery(".variation").removeClass("active");jQuery("#v"+i).addClass("active");jQuery(".checkalert").load(cpath+"sale/ajax.php?ne=check&id="+ID+"&Rb_ID="+i+"&Rb_Name="+n);return false;}

// 🛠 Select değişiminde varyasyon kontrolü ve AJAX ile stok/fiyat güncelleme
jQuery('#select_options').on('change',function(){var n=jQuery("#select_options option:selected").data('name'),i=jQuery("#select_options option:selected").data('id');jQuery(".checkalert").load(cpath+"sale/ajax.php?ne=check&id="+ID+"&Rb_ID="+i+"&Rb_Name="+n);});


// 💰 İndirim kodu uygulama fonksiyonu (ID: öğe ID, Price: fiyat, inputID: fiyat güncellenecek input)
function discount(e){var i=e.getAttribute("id"),p=e.getAttribute("data-price"),inp=e.getAttribute("inputID"),k=jQuery("#ikod").val();show('.discalert');jQuery(".discalert").html('<img src="'+weburl+'/'+crmpath+'/assets/img/loading.gif" style="height:16px;margin-top:-5px">');jQuery(".discalert").load(cpath+"sale/ajax.php?ne=discount&ikod="+k+"&price="+p+"&inputID="+inp);return false;}


// 🛒 Sepet verilerini getirir ve günceller
function GetCount(count) {
    if(jQuery(".qnotification")[0]) jQuery(".qnotification").load(cpath+"account/ajax.php?islem=qnotification");
    jQuery.getJSON(cpath+"sale/ajax.php?ne=basket&islem=basketData", function(data) {
        jQuery('.qbasket, .q2basket, #qbar').html(data.items.length); jQuery('.pbasket, .p2basket').html(data.total_price?data.total_price:'0.00');
        if(jQuery("#cart")[0]) jQuery("#cart").load(cpath+"sale/basket.php");
        if(data.items.length===0) { jQuery('.mbasket').html('<p style="text-align:center;">Sepet Boş</p>'); return; }
        let basketHtml = '<div class="v3-row" style="height:180px;overflow:auto;margin-right:-14px;margin-left:-5px;">';
        data.items.forEach(function(item){ basketHtml += "<div class='v3-media' style='padding-bottom:5px;margin-bottom:-5px;border-bottom:1px solid #ccc;position:relative'><div class='v3-media-left'><a href='"+item.link+"' style='width:50px;overflow:hidden;display:block;height:60px;border:1px solid #ccc;border-radius:10px;'><img class='v3-media-object' src='"+item.image+"' style='max-width: 100%;' alt='"+item.name+"'></a></div><div class='v3-media-body'><p class='v3-media-heading' style='font-size:12px;width:90%;display:grid'>"+item.name+"</p><span style='font-size:12px;' class='text-warning'>"+item.quantity+" x "+(item.price?item.price:'Fiyat Yok')+"</span></div></div>"; });
        basketHtml += '</div>';
        basketHtml += "<div class='v3-row' style='position:absolute; left:25px; bottom:15px; width:95%;'><div class='v3-col-md-6' style='text-align:right;padding:0px 2px;'><a href='?eticaret/sepet' class='v3-btn v3-btn-xs v3-btn-warning' style='padding:5px !important;width:100%;'><i class='fa fa-shopping-basket' aria-hidden='true'></i> Sepete Git</a></div><div class='v3-col-md-6' style='text-align:right;padding:0px 2px;'>"+(parseFloat(data.total_price) > 0 ? "<a href='?eticaret/odeme/adres#adres' class='v3-btn v3-btn-xs v3-btn-success' style='padding:5px !important;width:100%;'>Alışverişi Tamamla <i class='fa fa-chevron-right' aria-hidden='true'></i></a>" : "")+"</div></div>";
        jQuery('.mbasket').html(basketHtml);
    });
}

// 🛒 Sepete ürün ekleme fonksiyonu (ID: ürün, CID: mağaza/variant) ve bildirim gösterir
function AddBasket(ID,CID){var OpID=jQuery(this).attr("OpID")||"";var ShopID=CID||"";jQuery('#v3-notification').fadeOut('slow').fadeIn('slow');var basketurl=cpath+"sale/ajax.php?ne=basket&islem=ekle&id="+ID+"&s19="+ShopID+"&Rb_ID="+OpID;jQuery.get(basketurl).done(function(data){if(data.substr(0,4)=="url:"){location.href=data.replace('url:','');}else{jQuery('#v3-notification').html(data);jQuery('.AddBasket').attr('disabled','disabled');GetCount();stime('#v3-notification','show','3200');setTimeout(function(){jQuery('.AddBasket').removeAttr('disabled');},3200);}});}

// 📝 Form verilerini AJAX ile gönderir ve bildirim gösterir (url: hedef, id: form selector)
function AddBasketForm(url,id){jQuery('#v3-notification').fadeOut('slow').fadeIn('slow');jQuery.post(url,jQuery(id).serialize()).done(function(data){jQuery('#v3-notification').html(data);GetCount();stime('#v3-notification','show','3200');});return false;}

// 🛒 Sepet miktarını günceller (ID: ürün ID'si, Op: '+1' veya '-1')
function UpBasket(ID,Op){var qty=parseInt(jQuery("#qty"+ID).val())||0;if(Op=="+1"){qty+=1}else if(Op=="-1"){qty=Math.max(0,qty-1)}jQuery('#v3-notification').fadeOut('slow').fadeIn('slow');var basketurl=cpath+"sale/ajax.php?ne=basket&islem=guncelle&adet="+qty+"&id="+ID;jQuery.get(basketurl).done(function(data){if(data.substr(0,4)=="url:"){location.href=data.replace('url:','')}else{jQuery('#v3-notification').html(data);jQuery(".sumbasket").load(cpath+"sale/ajax.php?ne=basket&islem=ozet");GetCount();stime('#v3-notification','show','3200')}});}

// 🖨️ Belirtilen div içeriğini yazdırır (divId: yazdırılacak div ID'si)
function divyaz(divId){var printContents=document.getElementById(divId).innerHTML,originalContents=document.body.innerHTML;document.body.innerHTML="<html><head><title></title></head><body>"+printContents+"</body>";window.print();document.body.innerHTML=originalContents;}

// 📋 Belirtilen elementin metnini panoya kopyalar (element: DOM elementi)
var $cc=jQuery.noConflict();function copyToClipboard(element){var $temp=$cc("<input>");$cc("body").append($temp);$temp.val($cc(element).text()).select();document.execCommand("copy");$temp.remove();alert('Hafızaya Kopyalandı, Ctrl+V ile Yapıştırabilirsiniz.');}

// 🛒 Sidebar sepetini yükler
function sbasket(){jQuery("#rside").load(cpath+"sale/ajax.php?ne=basket&islem=mbasket");}

// ✏️ Input veya textarea'ya metin ekler (id: element ID, text: eklenecek metin)
function addTextTag(id,text){document.getElementById(id).value+=text;}

// ➕ Belirtilen elemente CSS sınıfı ekler (element: selector, cls: sınıf adı)
function addClass(element,cls){jQuery(element).addClass(cls);}

// ➖ Belirtilen elementten CSS sınıfını kaldırır (element: selector, cls: sınıf adı)
function removeClass(element,cls){jQuery(element).removeClass(cls);}

// 💡 Tooltip etkinleştirme (şimdilik yorum satırı)
//jQuery(function(){ jQuery('[data-toggle="tooltip"]').tooltip(); });

// ❌ Div silme butonları için onClick işlemleri (tek satırda sıkıştırıldı)
jQuery(document).on('click','.btn-delete-div',function(){var $this=jQuery(this),$div=$this.closest('.mdiv,.hdiv,.cparent'),box=jQuery("#mb-remove-row");box.addClass("open");box.find(".mb-control-yes").on("click",function(){jQuery('#preload').fadeIn('slow');box.removeClass("open");jQuery.get($this.data('href'),function(){$div.hide("slow",function(){$div.remove();jQuery('#preload').fadeOut('slow');});});});box.find(".mb-control-close").on("click",function(){box.removeClass("open");});});

// ⏳ Yükleniyor butonları için tıklama işlemi, butonu devre dışı bırakır ve loading göstergesi ekler
jQuery(document).ready(function(){jQuery(".loading").click(function(){setTimeout(function(){jQuery(".loading").attr("disabled",true).html('<img src="'+weburl+'/'+crmpath+'/assets/img/loading.gif" style="height:16px;margin-top:-5px"> <?php echo translate("Yükleniyor")?>');},100);});});

// 🔍 check_data inputları için AJAX kontrol, sonucu belirtilen elemana yazar
jQuery(document).ready(function(){jQuery('.check_data').keyup(function(){var v=jQuery(this).val(),u=jQuery(this).data("url"),r=jQuery(this).data("result");if(v!=''){jQuery.ajax({url:u+'&val='+v,type:'POST',success:function(res){document.getElementById(r).innerHTML=res;}});}});});

// 🖼️ Modal açma ve iframe/ajax yükleme işlemleri
jQuery(function(){jQuery(".mfrm,.majx").click(function(){var t=jQuery(this).attr("data-title"),u=jQuery(this).attr("data-url"),type=jQuery(this).attr("modal-type"),width=jQuery(this).attr("modal-width"),refSRC=jQuery(this).attr("data-ref"),refFNC=jQuery(this).attr("data-fnc"),theModal="#myModal";jQuery(".v3-modal-title").text(t);if(type!=undefined) jQuery(theModal).addClass(type);jQuery(theModal).modal('toggle');if(typeof mobile!=="undefined"&&mobile==""&&width!=undefined) jQuery(theModal+" .v3-modal-dialog").css('width',width);if(jQuery(this).hasClass("mfrm")){jQuery(theModal+" .v3-modal-body").html('<iframe src="" name="modal" id="mfrm" scrolling="no" frameborder="0" style="width:100%;height:93vh;" allowfullscreen></iframe>');jQuery(theModal+" iframe").attr('src',u);jQuery(theModal+" button.close").click(function(){jQuery(theModal+" iframe").attr('src','about:blank');});}else{jQuery(theModal+" .v3-modal-body").load(u);}if(refSRC!=undefined) jQuery(theModal+" .close").attr('onclick','location.href="'+refSRC+'"');if(refFNC!=undefined) jQuery(theModal+" .close").attr('onclick',refFNC);});jQuery('#myModal').on('hidden.bs.modal',function(){jQuery(this).removeClass('right left');jQuery('.v3-modal-dialog',this).css('width','');});});

// ⬇️ More Div: Tıklayınca yükseklik değiştirir (100px ↔ auto)
function more(id){jQuery(id).css('height',jQuery(id).height()!=100?'100':'auto');}

// ⬆️⬇️ Adet arttırma/azaltma (ID: input ID, Op: + veya -)
function qty(ID,Op){var old=jQuery("#qty"+ID).val(),newVal=Op=="+"?parseFloat(old)+1:Math.max(0,parseFloat(old)-1);jQuery("#qty"+ID).val(newVal);}

// ✅ Checkbox toggle (id: checkbox ID)
function cbox(id){var $=jQuery;if($(""+id).is(":checked")){$(id).prop("checked",false);$(".actived").toggleClass("actived");$(id+"a").toggleClass("actived");}else{$(id).prop("checked",true);$(".actived").toggleClass("actived");$(id+"a").toggleClass("actived");}}

// 🔄 Basit load fonksiyonu (ne: URL, did: hedef selector)
var loadFunction=function(ne,did){jQuery(did).load(ne);};

// 🔄 Input değerini başka inputa aktarır (s: kaynak, t: hedef)
function vtransfer(s,t){jQuery(t).val(jQuery(s).val());}

// 📍 İki koordinat arası mesafeyi hesaplar ve elemente yazar (latlng1, latlng2: "lat,lon", id: hedef selector, sum: callback)
function GetDistance(latlng1,latlng2,id,sum){var l1=latlng1.split(','),l2=latlng2.split(','),lat1=l1[0],lon1=l1[1],lat2=l2[0],lon2=l2[1];if(lat1==lat2&&lon1==lon2){return 0}else{var r1=Math.PI*lat1/180,r2=Math.PI*lat2/180,theta=lon1-lon2,rt=Math.PI*theta/180,dist=Math.sin(r1)*Math.sin(r2)+Math.cos(r1)*Math.cos(r2)*Math.cos(rt);if(dist>1){dist=1}dist=Math.acos(dist)*180/Math.PI*60*1.1515*1.609344;var unit;dist<1?(dist=(dist*1e3).toFixed(0),unit='m',sum!=""&&sum('1')):(dist=dist.toFixed(2),unit='km',sum!=""&&sum(dist));jQuery(id).html(dist+' '+unit);}}

// ⏱ Zamanlayıcı fonksiyonu (time: "mm:ss", div: sayaç gösterilecek element, button: işlem butonu)
function timer(time,div,button){var t=time,interval=setInterval(function(){var a=t.split(':'),m=parseInt(a[0],10),s=parseInt(a[1],10);s--;if(s<0){m--;s=59}if(m<=0&&s<=0){clearInterval(interval);$(div).html('<a onclick="timer(\''+time+'\',\''+div+'\',\''+button+'\');" style="font-size:10px; cursor:pointer;"><i class="fa fa-refresh" aria-hidden="true"></i> Tekrar Gönder</a>');$(button).html("Süreniz Doldu").prop('disabled',true);return}var secStr=(s<10?'0':'')+s;$(div).html(m+':'+secStr);$(button).prop('disabled',false).html("Gönder");t=m+':'+secStr},1000);}

// 🔹 Sayfa yüklendiğinde body sınıfı ekle
jQuery(document).ready(function(){jQuery('body').addClass('watolye');});

// 🔹 Toggle göster/gizle
function toggle(id,effect){jQuery(id).toggle(effect,function(){});}

// 🔹 AJAX ile otomatik kaydet (clients veya post)
function AjaxKaydet(ne){
    var ref,text;
    if(ne=='clients'){ref='?panel/clients/sclient/'+sayfa3;text='<i class="fa fa-check"></i> Bilgiler Güncellendi<br><a href="?panel/clients" style="margin-left:15px;color:white;"><b>Müşterilerim</b></a>';}
    else{ref='?panel/post/spost/'+sayfa3;text='<i class="fa fa-check"></i> İlan Güncellendi<br><a href="?panel/posts" style="margin-left:15px;color:white;"><b>İlanlarım</b></a>';}
    for(var dilan in CKEDITOR.instances) CKEDITOR.instances[dilan].updateElement();
    jQuery.ajax({type:"POST",url:ref,data:jQuery('#autosave').serialize(),success:function(){
        jQuery('#v3-notification').html(text);
        setTimeout(function(){jQuery('#v3-notification').fadeIn('slow');},500);
        setTimeout(function(){jQuery('#v3-notification').delay(3000).fadeOut('slow');},500);
    }});
}

// 🔹 Karşılaştırma ekle/çıkar
function AddComp(ID,ne){jQuery('#v3-notification').fadeOut('slow');jQuery.get(cpath+"config/func.php?islem=compare&ne="+ne+"&id="+ID).done(function(data){jQuery('.v3-comp').toggleClass("active passive");data.substr(0,4)=="url:"?location.href=data.replace('url:',''):jQuery('#v3-notification').html(data);stime('#v3-notification','show','3200');});jQuery('body').append('<div id="compares" style="position: fixed; top: 10%; left: 10%; width: 80%; height: 80vh; background: white; z-index: 999999;"></div>');jQuery("#compares").load(cpath+"config/func.php?islem=compares");}

// 🔹 Favori ekle/çıkar
function AddFav(ID,ne){if(jQuery('.fav'+ID).hasClass("no_user")){alert('Üye Girişi Gerekli');return false;}jQuery('.fav'+ID).toggleClass("active");jQuery.get(cpath+"account/ajax.php?islem=fav&ne="+ne+"&id="+ID);jQuery(".qfav").load(cpath+"account/ajax.php?islem=qfav");}

// 🔹 Beğeni ekle/çıkar
function AddLike(ID,ne){if(jQuery('.like'+ID).hasClass("no_user")){alert('Üye Girişi Gerekli');return false;}jQuery('.like'+ID).toggleClass("active");jQuery.get(cpath+"account/ajax.php?islem=like&ne="+ne+"&id="+ID);}

// 🔹 Arkadaşlık ekle/çıkar
function AddFriend(ID,ne,sts){if(jQuery('.friend'+ID).hasClass("no_user")){alert('Üye Girişi Gerekli');return false;}jQuery('.friend'+ID).toggleClass("active");jQuery.get(cpath+"account/ajax.php?islem=friend&ne="+ne+"&durum="+sts+"&id="+ID);}

// 🔹 Dosya oku ve base64 aktar
function readFile(){if(this.files&&this.files[0]){var FR=new FileReader();FR.addEventListener("load",function(e){jQuery("#b64").val(e.target.result);});FR.readAsDataURL(this.files[0]);}}

// 🔹 AJAX POST form gönderimi
function AjaxPost(url,id,result,loadurl){jQuery('#preload').fadeIn('slow');jQuery.post(url,jQuery(id).serialize()).done(function(data){if(loadurl!=""){show(result.replace('#',''));jQuery(result).load(loadurl);jQuery('#preload').fadeOut('slow');}else if(result.substr(0,1)=="#"){show(result.replace('#',''));jQuery(result).text(data.trim().length>0?"<?php echo $sdil[103]?>":"<?php echo $sdil[104]?>");}else{setTimeout(function(){location.href=result!=""?result:"<?php echo $weburl;?>";},500);}});return false;}

// 🔹 Para formatlama
Number.prototype.formatMoney=function(f,d,s){d=typeof d==="undefined"?".":d;s=typeof s==="undefined"?",":s;var n=this,neg=n<0?"-":"";var w=parseInt(n=Math.abs(+n||0).toFixed(d))+"";var idx=w.length>3?w.length%3:0;return neg+(idx?w.substr(0,idx)+s:"")+w.substr(idx).replace(/(\d{3})(?=\d)/g,"$1"+s)+(d?d+Math.abs(n-w).toFixed(d).slice(2):"");};
function para(raw){return Number(raw).formatMoney(2,",",".");}
function wprice(raw){return Number(raw).formatMoney(2,",",".");}

// 🔹 AJAX GET işlemi, sonuç alanına veya yükleme URL'sine yönlendirme
function AjaxGet(url,result,loadurl,pl){
    if(pl!='nopl') jQuery('#preload').fadeIn('slow');
    jQuery.get(url).done(function(data){
        if(loadurl!=""){show(result.replace('#',''));jQuery(result).load(loadurl);jQuery('#preload').fadeOut('slow');}
        else if(result.substr(0,1)!=""){
            if(result.substr(0,1)=="#"){
                show(result.replace('#',''));
                jQuery(result).text(data.trim().length>0?"<?php echo $sdil[103]?>":"<?php echo $sdil[104]?>");
            }else{setTimeout(function(){location.href=result;},500);}
        }else{setTimeout(function(){location.href="<?php echo $weburl;?>";},500);}
    });
    return false;
}

//result "#" ile başlarsa success, url gönderilirse işlem sonu url, url gelmezse, weburl
/*
url:işlemURL
id:Post formID, boşsa Get olur
result:dönüş divID
*/

// 🔹 AJAX ile form gönderimi ve sonucu işleme (CKEditor, preload, basket güncelleme)
function AjaxPResult(url,id,result,pl,cke){
    if(cke!='') for(var f in CKEDITOR.instances) CKEDITOR.instances[f].updateElement();
    if(pl=='') jQuery('#preload').fadeIn('slow');
    var form=jQuery(id),fd=false;
    if(window.FormData) fd=new FormData(form[0]);
    jQuery.ajax({
        url:url,
        data:fd?fd:form.serialize(),
        cache:false,
        contentType:false,
        processData:false,
        type:'POST',
        success:function(data){
            if(data.substr(0,4)=="url:") location.href=data.replace('url:','');
            else if(data.substr(0,1)=="#"){hide('preload');show(result.replace('#',''));jQuery(result).html(data);}
            else if(result.substr(0,5)=="load:"&&result.substr(5,5)=="cart"){
                hide('preload');
                jQuery("#cart").load(cpath+"sale/basket.php");
                jQuery(".qbasket").load(cpath+"sale/ajax.php?ne=basket&islem=qbasket");
                jQuery(".pbasket").load(cpath+"sale/ajax.php?ne=basket&islem=pbasket");
                jQuery(".mbasket").load(cpath+"sale/ajax.php?ne=basket&islem=mbasket");
                jQuery(".sumbasket").load(cpath+"sale/ajax.php?ne=basket&islem=ozet");
            }else{
                hide('preload');show(result.replace('#',''));
                if(pl=='') setTimeout(function(){hide(result);},10000);
                jQuery(result).html(data);
            }
        }
    });
    return false;
}

// 📡 AJAX gönderimi ve sonuç işleme (url: POST adresi, id: form selector, result: sonuç div/selector, pl: preload kontrol, cke: CKEditor varlığı)
function AjaxGResult(url,id,result,pl,cke){if(cke!='')for(var f in CKEDITOR.instances)CKEDITOR.instances[f].updateElement();if(pl!='nopl')jQuery('#preload').fadeIn('slow');jQuery.post(url,jQuery(id).serialize()).done(function(data){if(data.substr(0,4)=="url:")location.href=data.replace('url:','');else if(result.substr(0,1)=="#"){hide('preload');show(result.replace('#',''));jQuery(result).html(data);}else if(result.substr(0,5)=="load:"&&result.substr(5,5)=="ozet"){hide('preload');}else{hide('preload');show(result.replace('#',''));jQuery(result).html(data);}});return false;}

// 🔹 Modal boyut ayarı (data-size="small"/"large" ile)
jQuery(document).on('click','[data-size]',function(e){e.preventDefault();var m=document.getElementById("modal-size");if(jQuery(this).data('size')=="small")m.className+=" v3-modal-sm";else if(jQuery(this).data('size')=="large")m.className+=" v3-modal-lg";});

// 🔹 Data-form ile AJAX form gönderimi ve CKEditor desteği
jQuery(document).on('click','[data-form]',function(e){
    e.preventDefault();jQuery('#preload').fadeIn('slow');var _this=jQuery(this);_this.attr('disabled','true');
    var cke=jQuery(_this.data('cke'));if(cke!=''){for(var ckeform in CKEDITOR.instances)CKEDITOR.instances[ckeform].updateElement();}
    var form=jQuery(_this.data('form')),formdata=false;if(window.FormData)formdata=new FormData(form[0]);
    jQuery.ajax({url:_this.data('url'),data:formdata?formdata:form.serialize(),cache:false,contentType:false,processData:false,type:'POST',success:function(data){
        if(_this.data('msg').length){show('#v3-notification');var rtxt=_this.data('burl')!==undefined?"<br>Yönlendiriliyorsunuz...":"";jQuery("#v3-notification").html('<i class="fas fa-check" style="font-size:24px;"></i> '+_this.data('msg')+''+rtxt);form.find("input[type=text], input[type=email], input[type=number], input[type=date], textarea, select, radio, checkbox").val("");setTimeout(function(){hide('#v3-notification');if(_this.data('burl')!==undefined)location.href=_this.data('burl');},2500);}
        jQuery('#preload').fadeOut('slow');
    }});
    if(_this.data('aurl')){jQuery.ajax({url:_this.data('aurl'),data:formdata?formdata:form.serialize(),cache:false,contentType:false,processData:false,type:'POST'});}
});

// 🔹 Eleman göster/gizle fonksiyonu (attr: selector, sh: 'show' veya 'hide')
function ctoggle(attr,sh){if(sh=="hide")jQuery(attr).hide(100);else if(sh=="show")jQuery(attr).show(100);}

// 🔹 Elemanı gizleme fonksiyonu (attr: selector veya ID)
function hide(attr){jQuery(attr[0]=='.'||attr[0]=='#'?attr:'#'+attr).fadeOut("slow");}

// 🔹 Elemanı gösterme fonksiyonu (attr: selector veya ID)
function show(attr){jQuery(attr[0]=='.'||attr[0]=='#'?attr:'#'+attr).fadeIn("slow");}

// 🔹 Div görünür yapma (id: div ID'si)
function vtr(id){var d=document.getElementById(id);d.style.visibility="visible";d.style.display="contents";}

// 🔹 Div gizleme (id: div ID'si)
function htr(id){var d=document.getElementById(id);d.style.visibility="hidden";d.style.display="none";}

// 🔹 Belirli süre ile göster/gizle
function stime(id,islem,sure){if(islem=="show"){jQuery(id).fadeIn('slow');}else{jQuery(id).fadeOut('slow');}if(sure!=""){setTimeout(function(){jQuery(id).fadeOut('slow');},sure);}}

jQuery(document).ready(function () {
    for (let a = 0; a <= 10; a++) {
        let f = (a === 0) ? "" : a;

        // İlk yüklemede kontrol
        fvalid('dr', a);

        // Change ve keyup olayları
        jQuery('form.fcontrol' + f).on("change keyup", function () {
            fvalid('', a);
        });
    }

    function fvalid(e, a) {
        jQuery('.valert').remove();
        if (a === 0) { a = ""; }

        let c = 0; // checkbox hataları
        let i = 0; // input boşluk hataları

        jQuery('form.fcontrol' + a + ' .icontrol').each(function () {
            jQuery(this).removeClass("vclass");
            let valert = jQuery(this).attr('data-alert');
            let type = this.type;

            if (type === "checkbox") {
                if (jQuery(this).is(':checked')) {
                    jQuery(this).css("filter", "none");
                } else {
                    c++;
                    if (e !== 'dr') {
                        jQuery(this).addClass('vclass');
                        if (typeof valert !== "undefined") {
                            jQuery(this).after('<div class="valert">* ' + valert + '</div>');
                        }
                    }
                }
            } else {
                if (jQuery(this).val() === "") {
                    if (e !== 'dr') {
                        jQuery(this).addClass('vclass');
                        if (typeof valert !== "undefined") {
                            jQuery(this).after('<div class="valert">* ' + valert + '</div>');
                        }
                    }
                    i++;
                } else {
                    if (type === "email") {
                        let regex = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
                        if (!regex.test(jQuery(this).val())) {
                            jQuery(this).after('<div class="valert">* <?php echo translate("Mail Adresi Hatalı!")?></div>');
                            c++;
                        }
                    }
                    if (jQuery(this).attr("id") === "idn") {
                        if (jQuery(this).tck() === false) {
                            jQuery(this).after('<div class="valert">* <?php echo translate("IDN Hatalı!")?></div>');
                            c++;
                        }
                    }
                }
            }
        });

        if (c === 0 && i === 0) {
            jQuery('form.fcontrol' + a + ' button').prop('disabled', false);
        } else {
            jQuery('form.fcontrol' + a + ' button').prop('disabled', true);
        }
    }
});
//<form class="fcontrol">
//<input type="text" class="icontrol">
//</form>

// 🔹 Sayfa yüklendikten 3sn sonra .v3_mbox fade out
jQuery(window).on('load',function(){setTimeout(function(){jQuery('.v3_mbox').fadeOut()},3000);});

//<div class="v3_mbox"></div>
//!-- Fade Out -->

// 🔹 Sadece sayı giriş kontrolü
function IsNumeric(obj){var v="0123456789",n=true,c;for(var i=0;i<obj.value.length&&n;i++){c=obj.value.charAt(i);if(v.indexOf(c)===-1){obj.value=obj.value.substring(0,i);n=false;break;}}return n;}

// 🔹 Font boyutunu değiştir (kaynak: element ID, deger: artış/azalış px)
function degistir(kaynak,deger){var h=document.getElementById(kaynak),f=parseInt(window.getComputedStyle(h).fontSize,10);h.style.fontSize=(f+parseInt(deger,10))+'px';}

// Kullanım: <button onclick="degistir('ContentID','2')">+</button>

//var frmvalidator = new Validator("FormID");
//frmvalidator.addValidation("Zorunlu","req","Lütfen Adınızı Giriniz");
//frmvalidator.addValidation("max50","maxlen=50");
//frmvalidator.addValidation("Email","email");
//frmvalidator.addValidation("Numara","numeric");