<?php
$jsonFile = '../../ranking.json';
$data = json_decode(file_get_contents($jsonFile), true);
// Kelimeleri gruplama
$kelimeGruplari = [];
foreach ($data as $item) {
    $kelime = $item['kelime'];
    $kelimeGruplari[$kelime][] = $item;
}
// Tarihleri küçükten büyüğe sıralama
foreach ($kelimeGruplari as &$group) {
    usort($group, function ($a, $b) {
        return strtotime($a['tarih']) - strtotime($b['tarih']);
    });
}
$aylar = [
    "Jan" => "Ocak", "Feb" => "Şubat", "Mar" => "Mart", "Apr" => "Nisan", "May" => "Mayıs", "Jun" => "Haziran",
    "Jul" => "Temmuz", "Aug" => "Ağustos", "Sep" => "Eylül", "Oct" => "Ekim", "Nov" => "Kasım", "Dec" => "Aralık"
];
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
	<title>SEO Kelime Raporu Grafik</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <script type="text/javascript">
        google.charts.load('current', {'packages':['corechart', 'line']});
        google.charts.setOnLoadCallback(drawCharts);
        function drawCharts() {
            <?php foreach ($kelimeGruplari as $kelime => $veriler): ?>
                var data_<?= md5($kelime) ?> = new google.visualization.DataTable();
                data_<?= md5($kelime) ?>.addColumn('string', 'Tarih');
                data_<?= md5($kelime) ?>.addColumn('number', 'Sıra');
                data_<?= md5($kelime) ?>.addColumn('number', 'Rekabet');
                data_<?= md5($kelime) ?>.addRows([
                    <?php foreach ($veriler as $v): ?>
                        ['<?= $aylar[date("M", strtotime($v['tarih']))] . " " . date("Y", strtotime($v['tarih'])) ?>', <?= intval($v['sira']) ?>, <?= intval($v['rekabet']) ?>],
                    <?php endforeach; ?>
                ]);
                var options_<?= md5($kelime) ?> = {
                    chart: { title: '<?= $kelime ?>' },
                    curveType: 'function',
                    width: '100%',
                    height: 250,
                    legend: { position: 'none' },
                    vAxis: { direction: -1, gridlines: { count: 3 }, viewWindow: { min: 1 } },
                    hAxis: { textStyle: { fontSize: 10 } }
                };
                var chart_<?= md5($kelime) ?> = new google.visualization.LineChart(document.getElementById('chart_div_<?= md5($kelime) ?>'));
                chart_<?= md5($kelime) ?>.draw(data_<?= md5($kelime) ?>, options_<?= md5($kelime) ?>);
            <?php endforeach; ?>
        }
    </script>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f7f7f7; }
        .container { display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 15px; }
        .chart-box { background: white; padding: 10px; border-radius: 8px; box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1); }
        h3 { font-size: 16px; margin-bottom: 8px; color: #333; }
    </style>
</head>
<body>
<div class="container">
    <?php foreach ($kelimeGruplari as $kelime => $veriler): ?>
        <div class="chart-box">
            <h3><?= $kelime ?></h3>
            <div id="chart_div_<?= md5($kelime) ?>"></div>
        </div>
    <?php endforeach; ?>
</div>
</body>
</html>