<?php
header('Content-type: text/html; charset=utf-8');
if ($_GET["type"] == "transfer") {
	$data = json_decode(file_get_contents('php://input'), true);
	if (empty($data)) { echo 'Geçersiz veya boş veri geldi.'; exit; }
	$translationFileLocal = $_SERVER['DOCUMENT_ROOT'] . "/deppo/datas/translations.json";
	if (file_put_contents($translationFileLocal, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT))) {
		echo 'Çeviri verileri başarıyla güncellendi.';
	} else {
		echo 'Dosya kaydedilemedi.';
	}
} elseif ($_GET["type"] == "add") {
    // Gelen metin (key) verisini al
    $metin = $_POST['metin'] ?? '';
    if (empty($metin)) { exit; }
    // Çeviri dosyasının yerel yolu
    $translationFileLocal = $_SERVER['DOCUMENT_ROOT'] . "/deppo/datas/translations.json";
    // Dosya var mı kontrol et
    if (file_exists($translationFileLocal)) {
        // Dosyayı oku
        $translations = json_decode(file_get_contents($translationFileLocal), true);
        // Mevcut çevirilerde 'key' değerini kontrol et
        $found = false;
        foreach ($translations as $id => $translation) {
            if ($translation['key'] === $metin) {
                $found = true; // Eğer key zaten varsa, bulduk
                break;
            }
        }
        if ($found) {
            //echo json_encode(['info' => 'Bu metin zaten mevcut, ekleme yapılmadı.']);
            exit; // Eğer metin zaten varsa, işlem durdurulur
        }
        // Benzersiz ID oluştur
        $newId = max(array_keys($translations)) + 1;
        // Yeni çeviriyi ekle
        $translations[$newId] = [
            "key" => $metin,
            "lang1" => $metin, // varsayılan olarak metnin kendisini "lang1" olarak ekle
        ];
        // JSON verisini dosyaya kaydet
        if (file_put_contents($translationFileLocal, json_encode($translations, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT))) {
            //echo json_encode(['success' => 'Yeni çeviri başarıyla eklendi.']);
        } else {
            //echo json_encode(['error' => 'Çeviri dosyasına ekleme yapılamadı.']);
        }
    } else {
        // Eğer dosya yoksa, yeni dosya oluştur ve metni ekle
        $translations = [
            1 => [
                "key" => $metin,
                "lang1" => $metin, // varsayılan olarak metnin kendisini "lang1" olarak ekle
            ]
        ];
        // Yeni dosya oluştur ve veriyi ekle
        if (file_put_contents($translationFileLocal, json_encode($translations, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT))) {
            //echo json_encode(['success' => 'Yeni çeviri dosyası oluşturuldu ve ekleme yapıldı.']);
        } else {
            //echo json_encode(['error' => 'Yeni dosya oluşturulamadı.']);
        }
    }
}
?>