<?php
require_once('config.php');
/**
 * Update Card Request
 * Kart Güncelleme İsteği Oluştur
 */
$request = new \Hepsipay\Request\UpdateCardRequest();
/**
 * Set Options
 * Ayarları Set Et
 */
$request->setOptions($options);
$request->setId("84095ee7-232a-4134-8be1-a6dd0135bff8"); // Kartı bilgisi tekil kodu (Guid değeridir.)
$request->setExpireMonth("12"); // Kart Son Kullanım Tarihi (2 haneli nümerik değerdir.)
$request->setExpireYear("18"); // Kart Son Kullanım Tarihi (2 haneli nümerik değerdir.)
$request->setMerchantUserId("User_2"); // Kullanıcı kodu (Maksimum 40 karakterdir.)
$request->setMerchantUserCardId("Bankxxx_yyy_kartı"); // Kullanıcı kartı bilgisi kodu (Maksimum 40 karakterdir.)
/**
 * Make Request
 * İsteği Oluştur
 */
$response = \Hepsipay\Model\UpdateCard::create($request);
/**
 * Print Response ve Request Details
 * Yanıtı ve İstek Detaylarını Yazdır
 */
echo "<pre>";
echo "\nRESPONSE\n\n";
print_r($response); // Response
echo "\nREQUEST\n\n";
print_r($request->toJsonString()); // Request
echo "</pre>";