<?php
namespace Hepsipay\Model;
use Hepsipay\Model\Auth;
use Hepsipay\Request\DeleteCardRequest;
use Hepsipay\Request\AuthRequest;
use Hepsipay\Model\Mapper\DeleteCardMapper;
class DeleteCard extends DeleteCardResource
{
    public static function create(DeleteCardRequest $request)
    {
        $authRequest = new AuthRequest();
        $authRequest->setOptions($request->getOptions());
        $authObject = Auth::create($authRequest);
        
        if($authObject !== false)
        {
            $rawResponse = parent::httpClient()->delete($request->getOptions()->getUrlCard(), parent::getBearerAuthorizationHttpHeaders($request, $authObject), $request->toJsonString());
            return DeleteCardMapper::create($rawResponse)->jsonDecode()->mapDeleteCard(new DeleteCard());
        }
        
        return false;
    }
}